/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.symmetry;

import java.util.Arrays;
import java.util.Hashtable;
import java.util.Map;
import javajs.util.Measure;
import javajs.util.P3;
import javajs.util.V3;
import org.jmol.java.BS;
import org.jmol.util.BSUtil;
import org.jmol.util.Edge;
import org.jmol.util.Logger;
import org.jmol.util.Node;
import org.jmol.viewer.Viewer;

public class CIPChirality {
    static final int NO_CHIRALITY = 0;
    static final int TIED = 0;
    static final int B_WINS = 1;
    static final int A_WINS = -1;
    Viewer vwr;
    Map<Integer, Integer> htPathPoints = new Hashtable<Integer, Integer>();

    public CIPChirality setViewer(Viewer vwr) {
        this.vwr = vwr;
        return this;
    }

    public int getChirality(Node atom) {
        int rs;
        block5: {
            CIPAtom a;
            rs = 0;
            if (atom.getCovalentBondCount() != 4 || !(a = new CIPAtom(atom, null, false)).set()) {
                return rs;
            }
            try {
                if (a.sortSubstituents()) {
                    rs = CIPChirality.getHandedness(a);
                }
            }
            catch (Throwable e) {
                System.out.println(e + " in CIPChirality");
                if (this.vwr.isJS) break block5;
                e.printStackTrace();
            }
        }
        if (Logger.debugging) {
            Logger.info(atom + " " + (rs == 1 ? "R" : (rs == 2 ? "S" : "")));
        }
        return rs;
    }

    static int getHandedness(CIPAtom a) {
        P3 p1 = (P3)((Object)a.atoms[0].atom);
        P3 p2 = (P3)((Object)a.atoms[1].atom);
        P3 p3 = (P3)((Object)a.atoms[2].atom);
        P3 p4 = (P3)((Object)a.atoms[3].atom);
        V3 vNorm = new V3();
        float d = Measure.getNormalThroughPoints(p1, p2, p3, vNorm, new V3());
        return Measure.distanceToPlaneV(vNorm, d, p4) > 0.0f ? 1 : 2;
    }

    static int breakTie(CIPAtom a, CIPAtom b) {
        int score = a.checkDuplicate(b);
        if (score != 0) {
            return score;
        }
        score = a.checkRule1b(b);
        if (score != 0) {
            return score;
        }
        if (a.atom == b.atom || !a.set() || !b.set() || a.isTerminal || b.isTerminal || a.isDuplicate && b.isDuplicate) {
            return 0;
        }
        if (Logger.debugging) {
            Logger.info("tie for " + a + " and " + b);
        }
        if ((score = CIPChirality.compareAB(a, b, true)) != 0) {
            return score;
        }
        a.sortSubstituents();
        b.sortSubstituents();
        return CIPChirality.compareAB(a, b, false);
    }

    private static int compareAB(CIPAtom a, CIPAtom b, boolean ignoreDuplicate) {
        for (int i = 0; i < a.nAtoms; ++i) {
            int score;
            CIPAtom ai = a.atoms[i];
            CIPAtom bi = b.atoms[i];
            System.out.println("compareAB " + ai + " " + bi + " ignoreDup=" + ignoreDuplicate);
            int n = score = ignoreDuplicate ? ai.checkRules12(bi) : CIPChirality.breakTie(ai, bi);
            if (score == 0) continue;
            System.out.println((score == 1 ? bi + " beatsi " + ai : ai + " beatsi " + bi) + " " + ignoreDuplicate);
            return score;
        }
        return 0;
    }

    private class CIPAtom
    implements Comparable<CIPAtom> {
        Node atom;
        int massNo;
        int elemNo;
        CIPAtom parent;
        boolean isDuplicate = true;
        boolean isTerminal;
        boolean isSet;
        int isBelow;
        BS bsPath;
        int rootDistance;
        CIPAtom[] atoms;
        int nAtoms;

        public String toString() {
            return (this.atom == null ? "<null>" : this.atom.toString()) + (this.isDuplicate ? " *" : " " + (this.isBelow + 1));
        }

        CIPAtom(Node atom, CIPAtom parent, boolean isDuplicate) {
            if (atom == null) {
                return;
            }
            this.atom = atom;
            this.parent = parent;
            this.isTerminal = atom.getCovalentBondCount() == 1;
            this.elemNo = atom.getElementNumber();
            this.massNo = atom.getNominalMass();
            this.bsPath = parent == null ? new BS() : BSUtil.copy(parent.bsPath);
            int iatom = atom.getIndex();
            if (this.bsPath.get(iatom)) {
                isDuplicate = true;
                this.rootDistance = CIPChirality.this.htPathPoints.get(new Integer(iatom));
            } else {
                this.bsPath.set(iatom);
                this.rootDistance = parent == null ? 1 : parent.rootDistance + 1;
                CIPChirality.this.htPathPoints.put(new Integer(iatom), new Integer(this.rootDistance));
            }
            this.isDuplicate = isDuplicate;
        }

        boolean set() {
            if (this.isTerminal || this.isSet) {
                return true;
            }
            this.isSet = true;
            this.atoms = new CIPAtom[this.parent == null ? 4 : 3];
            if (this.atom == null) {
                System.out.println("HOHO");
            }
            int nBonds = this.atom.getBondCount();
            Edge[] bonds = this.atom.getEdges();
            int pt = 0;
            block5: for (int i = 0; i < nBonds; ++i) {
                Edge bond = bonds[i];
                if (!bond.isCovalent()) continue;
                Node other = bond.getOtherAtomNode(this.atom);
                boolean isParent = this.parent != null && this.parent.atom == other;
                int order = bond.getCovalentOrder();
                switch (order) {
                    case 3: {
                        if (!this.addAtom(pt++, other, isParent)) {
                            this.isTerminal = true;
                            return false;
                        }
                    }
                    case 2: {
                        if (!this.addAtom(pt++, other, order != 2 || isParent)) {
                            this.isTerminal = true;
                            return false;
                        }
                    }
                    case 1: {
                        if (isParent || this.addAtom(pt++, other, order != 1)) continue block5;
                        this.isTerminal = true;
                        return false;
                    }
                    default: {
                        this.isTerminal = true;
                        return false;
                    }
                }
            }
            this.isTerminal = pt == 0;
            this.nAtoms = pt;
            while (pt < this.atoms.length) {
                this.atoms[pt] = new CIPAtom(null, null, true);
                ++pt;
            }
            Arrays.sort(this.atoms);
            return !this.isTerminal;
        }

        private boolean addAtom(int i, Node other, boolean isDuplicate) {
            if (i >= this.atoms.length) {
                return false;
            }
            this.atoms[i] = new CIPAtom(other, this, isDuplicate);
            System.out.println(this + " adding " + i + " " + this.atoms[i]);
            return true;
        }

        boolean sortSubstituents() {
            int i;
            int i2;
            boolean allowTie = this.parent != null;
            int n = this.atoms.length;
            for (i2 = 0; i2 < n; ++i2) {
                this.atoms[i2].isBelow = 0;
            }
            for (i2 = 0; i2 < n; ++i2) {
                CIPAtom a = this.atoms[i2];
                block12: for (int j = i2 + 1; j < n; ++j) {
                    CIPAtom b = this.atoms[j];
                    int score = a.compareTo(b);
                    if (Logger.debugging) {
                        Logger.info("comparing parent=" + this.parent + " this=" + this + ": " + n + " " + i2 + " " + j + " " + a + " and " + b + " = " + score);
                    }
                    block0 : switch (score) {
                        case 1: {
                            ++a.isBelow;
                            System.out.println(b + " beatsc " + a);
                            continue block12;
                        }
                        case -1: {
                            ++b.isBelow;
                            System.out.println(a + " beatsc " + b);
                            continue block12;
                        }
                        case 0: {
                            switch (CIPChirality.breakTie(a, b)) {
                                case 0: {
                                    if (!allowTie) {
                                        return false;
                                    }
                                }
                                case 1: {
                                    ++a.isBelow;
                                    System.out.println(b + " beatst " + a);
                                    break block0;
                                }
                                case -1: {
                                    ++b.isBelow;
                                    System.out.println(a + " beatst " + b);
                                }
                            }
                        }
                    }
                }
            }
            CIPAtom[] ret = new CIPAtom[n];
            for (i = 0; i < n; ++i) {
                ret[this.atoms[i].isBelow] = this.atoms[i];
            }
            if (Logger.debugging) {
                for (i = 0; i < n; ++i) {
                    Logger.info(this.atom + "[" + i + "]=" + ret[i]);
                }
            }
            this.atoms = ret;
            return true;
        }

        @Override
        public int compareTo(CIPAtom b) {
            int score = 0;
            score = this.checkRules12(b);
            return score != 0 ? score : this.checkDuplicate(b);
        }

        public int checkRules12(CIPAtom b) {
            int score = 0;
            score = this.checkRule1a(b);
            return score != 0 ? score : ((score = this.checkRule1b(b)) != 0 ? score : this.checkRule2(b));
        }

        int checkRule1a(CIPAtom b) {
            return b.atom == this.atom ? 0 : (b.atom == null ? -1 : (this.atom == null ? 1 : (b.elemNo != this.elemNo ? (b.elemNo < this.elemNo ? -1 : 1) : 0)));
        }

        int checkRule1b(CIPAtom b) {
            return !b.isDuplicate || !this.isDuplicate ? 0 : (b.rootDistance < this.rootDistance ? 1 : (b.rootDistance > this.rootDistance ? -1 : 0));
        }

        int checkRule2(CIPAtom b) {
            return b.massNo < this.massNo ? -1 : (b.massNo > this.massNo ? 1 : 0);
        }

        int checkDuplicate(CIPAtom b) {
            return b.isDuplicate == this.isDuplicate ? 0 : (b.isDuplicate ? -1 : 1);
        }
    }
}

