/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.scriptext;

import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javajs.util.AU;
import javajs.util.CU;
import javajs.util.Lst;
import javajs.util.M3;
import javajs.util.M4;
import javajs.util.Measure;
import javajs.util.P3;
import javajs.util.P4;
import javajs.util.PT;
import javajs.util.Quat;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.api.Interface;
import org.jmol.api.JmolNMRInterface;
import org.jmol.api.JmolPatternMatcher;
import org.jmol.api.SymmetryInterface;
import org.jmol.atomdata.RadiusData;
import org.jmol.bspt.Bspt;
import org.jmol.bspt.CubeIterator;
import org.jmol.c.VDW;
import org.jmol.i18n.GT;
import org.jmol.java.BS;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.BondSet;
import org.jmol.modelset.ModelSet;
import org.jmol.script.SV;
import org.jmol.script.ScriptEval;
import org.jmol.script.ScriptException;
import org.jmol.script.ScriptMathProcessor;
import org.jmol.script.ScriptParam;
import org.jmol.script.T;
import org.jmol.util.BSUtil;
import org.jmol.util.ColorEncoder;
import org.jmol.util.Escape;
import org.jmol.util.JmolMolecule;
import org.jmol.util.Logger;
import org.jmol.util.Node;
import org.jmol.util.Parser;
import org.jmol.util.Point3fi;
import org.jmol.util.SimpleUnitCell;
import org.jmol.viewer.FileManager;
import org.jmol.viewer.JC;
import org.jmol.viewer.Viewer;

public class MathExt {
    private Viewer vwr;
    private ScriptEval e;
    private Random rand;
    private JmolPatternMatcher pm;

    public MathExt init(Object se) {
        this.e = (ScriptEval)se;
        this.vwr = this.e.vwr;
        return this;
    }

    public boolean evaluate(ScriptMathProcessor mp, T op, SV[] args, int tok) throws ScriptException {
        switch (tok) {
            case 134217749: 
            case 0x8000202: 
            case 134218244: 
            case 134218245: 
            case 134218246: 
            case 134218250: {
                return this.evaluateMath(mp, args, tok);
            }
            case 1275068928: 
            case 1275068929: 
            case 1275068930: 
            case 1275068931: 
            case 1275069441: 
            case 1275334681: 
            case 1275335685: {
                return this.evaluateList(mp, op.intValue, args);
            }
            case 0x10000040: {
                if (args.length == 0) {
                    mp.wasX = false;
                }
            }
            case 1275068418: {
                return this.evaluateArray(mp, args, tok == 1275068418 && op.tok == 0x100000D1);
            }
            case 0x8000003: 
            case 134221850: {
                return this.evaluateQuaternion(mp, args, tok);
            }
            case 0x4C000004: {
                return this.evaluateBin(mp, args);
            }
            case 134221829: {
                return this.evaluateCache(mp, args);
            }
            case 1275068934: 
            case 1275068935: {
                return this.evaluateRowCol(mp, args, tok);
            }
            case 1765808134: {
                return this.evaluateColor(mp, args);
            }
            case 134221831: {
                return this.evaluateCompare(mp, args);
            }
            case 0x8000008: 
            case 1228931587: 
            case 1275203608: {
                return this.evaluateConnected(mp, args, tok, op.intValue);
            }
            case 1814695966: {
                return this.evaluateUnitCell(mp, args, op.tok == 0x100000D1);
            }
            case 134353926: {
                return this.evaluateContact(mp, args);
            }
            case 134221834: {
                return this.evaluateData(mp, args);
            }
            case 1275069442: 
            case 0x4C000404: {
                return this.evaluateDotDist(mp, args, tok, op.intValue);
            }
            case 1275069443: {
                if (op.tok == 0x100000D1) {
                    return this.evaluateDotDist(mp, args, tok, op.intValue);
                }
            }
            case 0x8000001: 
            case 1745489939: {
                return this.evaluateMeasure(mp, args, op.tok);
            }
            case 134222849: 
            case 1228935687: {
                return this.evaluateLoad(mp, args, tok == 1228935687);
            }
            case 1275068427: {
                return this.evaluateFind(mp, args);
            }
            case 1287653388: 
            case 1825200146: {
                return this.evaluateFormat(mp, op.intValue, args, tok == 1825200146);
            }
            case 134320141: {
                return this.evaluateUserFunction(mp, (String)op.value, args, op.intValue, op.tok == 0x100000D1);
            }
            case 1275068449: 
            case 1275072526: 
            case 1275082245: {
                return this.evaluateGetProperty(mp, args, tok, op.tok == 0x100000D1);
            }
            case 136314895: {
                return this.evaluateHelix(mp, args);
            }
            case 134217750: 
            case 134219265: 
            case 134219266: {
                return this.evaluatePlane(mp, args, tok);
            }
            case 134218759: 
            case 134222350: 
            case 134222850: 
            case 134238732: {
                return this.evaluateScript(mp, args, tok);
            }
            case 1275068932: 
            case 1275069446: 
            case 1275069447: {
                return this.evaluateString(mp, op.intValue, args);
            }
            case 134217751: {
                return this.evaluatePoint(mp, args);
            }
            case 0x8000022: {
                return this.evaluatePointGroup(mp, args);
            }
            case 134256131: {
                return this.evaluatePrompt(mp, args);
            }
            case 134219268: {
                return this.evaluateRandom(mp, args);
            }
            case 1275068432: {
                return this.evaluateIn(mp, args);
            }
            case 1275072532: {
                return this.evaluateModulation(mp, args);
            }
            case 1275068443: {
                return this.evaluateReplace(mp, args);
            }
            case 0x8000404: 
            case 134218757: 
            case 1237320707: {
                return this.evaluateSubstructure(mp, args, tok, op.tok == 0x100000D1);
            }
            case 1275068425: 
            case 1275068444: {
                return this.evaluateSort(mp, args, tok);
            }
            case 1296041986: {
                return this.evaluateSymop(mp, args, op.tok == 0x100000D1);
            }
            case 1275068445: {
                return this.evaluateTensor(mp, args);
            }
            case 134217759: {
                return this.evaluateWithin(mp, args);
            }
            case 134221856: {
                return this.evaluateWrite(mp, args);
            }
        }
        return false;
    }

    private boolean evaluatePointGroup(ScriptMathProcessor mp, SV[] args) {
        T3[] pts = null;
        P3 center = null;
        float distanceTolerance = Float.NaN;
        float linearTolerance = Float.NaN;
        block0 : switch (args.length) {
            case 4: {
                linearTolerance = args[3].asFloat();
            }
            case 3: {
                distanceTolerance = args[2].asFloat();
            }
            case 2: {
                int i;
                BS bsAtoms;
                switch (args[1].tok) {
                    case 8: {
                        center = SV.ptValue((SV)args[1]);
                        break;
                    }
                    case 10: {
                        bsAtoms = SV.getBitSet((SV)args[1], (boolean)false);
                        int iatom = bsAtoms.nextSetBit(0);
                        if (iatom < 0 || iatom >= this.vwr.ms.ac || bsAtoms.cardinality() != 1) {
                            return false;
                        }
                        if (SV.sValue((T)args[0]).equalsIgnoreCase("spaceGroup")) {
                            Lst lst = this.vwr.ms.generateCrystalClass(iatom, P3.new3((float)Float.NaN, (float)Float.NaN, (float)Float.NaN));
                            pts = new T3[lst.size()];
                            i = pts.length;
                            while (--i >= 0) {
                                pts[i] = (T3)lst.get(i);
                            }
                            center = new P3();
                            if (args.length != 2) break;
                            distanceTolerance = 0.0f;
                            break;
                        }
                        center = this.vwr.ms.at[iatom];
                    }
                }
                if (pts != null) break;
            }
            case 1: {
                int i;
                BS bsAtoms;
                switch (args[0].tok) {
                    case 7: {
                        Lst points = args[0].getList();
                        pts = new T3[points.size()];
                        int i2 = pts.length;
                        while (--i2 >= 0) {
                            pts[i2] = SV.ptValue((SV)((SV)points.get(i2)));
                        }
                        break block0;
                    }
                    case 10: {
                        bsAtoms = SV.getBitSet((SV)args[0], (boolean)false);
                        Lst atoms = this.vwr.ms.getAtomPointVector(bsAtoms);
                        pts = new T3[atoms.size()];
                        i = pts.length;
                        while (--i >= 0) {
                            pts[i] = (T3)atoms.get(i);
                        }
                        break block0;
                    }
                    default: {
                        return false;
                    }
                }
            }
            default: {
                return false;
            }
        }
        SymmetryInterface pointGroup = this.vwr.getSymTemp().setPointGroup(null, (T3)center, pts, null, false, Float.isNaN(distanceTolerance) ? this.vwr.getFloat(0x22000026) : distanceTolerance, Float.isNaN(linearTolerance) ? this.vwr.getFloat(0x22000028) : linearTolerance, true);
        return mp.addXMap((Map)pointGroup.getPointGroupInfo(-1, null, true, null, 0, 1.0f));
    }

    private boolean evaluateUnitCell(ScriptMathProcessor mp, SV[] args, boolean isSelector) throws ScriptException {
        String op;
        boolean toPrimitive;
        int ptParam;
        SymmetryInterface u;
        P3[] ucnew;
        float scale;
        int lastParam;
        int iatom;
        block36: {
            int i;
            block37: {
                boolean haveUC;
                BS x1 = isSelector ? SV.getBitSet((SV)mp.getX(), (boolean)true) : null;
                iatom = (x1 == null ? this.vwr.getAllAtoms() : x1).nextSetBit(0);
                lastParam = args.length - 1;
                scale = 1.0f;
                switch (lastParam < 0 ? 0 : args[lastParam].tok) {
                    case 2: 
                    case 3: {
                        scale = args[lastParam].asFloat();
                        --lastParam;
                    }
                }
                int tok0 = lastParam < 0 ? 0 : args[0].tok;
                ucnew = null;
                Lst uc = null;
                switch (tok0) {
                    case 7: {
                        uc = args[0].getList();
                        break;
                    }
                    case 4: {
                        String s = args[0].asString();
                        if (s.indexOf("a=") != 0) break;
                        ucnew = new P3[4];
                        for (int i2 = 0; i2 < 4; ++i2) {
                            ucnew[i2] = new P3();
                        }
                        SimpleUnitCell.setOabc((String)s, null, (T3[])ucnew);
                    }
                }
                u = null;
                boolean bl = haveUC = uc != null;
                if (ucnew == null && haveUC && uc.size() < 4) {
                    return false;
                }
                int n = ptParam = haveUC ? 1 : 0;
                if (ucnew == null && !haveUC && tok0 != 8) {
                    P3[] p3Array;
                    SymmetryInterface symmetryInterface = u = iatom < 0 ? null : this.vwr.ms.getUnitCell((int)this.vwr.ms.at[iatom].mi);
                    if (u == null) {
                        P3[] p3Array2 = new P3[4];
                        p3Array2[0] = P3.new3((float)0.0f, (float)0.0f, (float)0.0f);
                        p3Array2[1] = P3.new3((float)1.0f, (float)0.0f, (float)0.0f);
                        p3Array2[2] = P3.new3((float)0.0f, (float)1.0f, (float)0.0f);
                        p3Array = p3Array2;
                        p3Array2[3] = P3.new3((float)0.0f, (float)0.0f, (float)1.0f);
                    } else {
                        p3Array = ucnew = u.getUnitCellVectors();
                    }
                }
                if (ucnew != null) break block36;
                ucnew = new P3[4];
                if (!haveUC) break block37;
                switch (uc.size()) {
                    case 3: {
                        ucnew[0] = new P3();
                        for (int i3 = 0; i3 < 3; ++i3) {
                            ucnew[i3 + 1] = P3.newP((T3)SV.ptValue((SV)((SV)uc.get(i3))));
                        }
                        break block36;
                    }
                    case 4: {
                        for (int i4 = 0; i4 < 4; ++i4) {
                            ucnew[i4] = P3.newP((T3)SV.ptValue((SV)((SV)uc.get(i4))));
                        }
                        break block36;
                    }
                    case 6: {
                        float[] params = new float[6];
                        for (i = 0; i < 6; ++i) {
                            params[i] = ((SV)uc.get(i)).asFloat();
                        }
                        SimpleUnitCell.setOabc(null, (float[])params, (T3[])ucnew);
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                break block36;
            }
            ucnew[0] = SV.ptValue((SV)args[0]);
            switch (lastParam) {
                case 3: {
                    for (int i5 = 1; i5 < 4; ++i5) {
                        ucnew[i5] = P3.newP((T3)SV.ptValue((SV)args[i5]));
                        ucnew[i5].sub((T3)ucnew[0]);
                    }
                    break;
                }
                case 1: {
                    Lst l = args[1].getList();
                    if (l != null && l.size() == 3) {
                        for (i = 0; i < 3; ++i) {
                            ucnew[i + 1] = SV.ptValue((SV)((SV)l.get(i)));
                        }
                        break;
                    }
                }
                default: {
                    return false;
                }
            }
        }
        if ((toPrimitive = "primitive".equalsIgnoreCase(op = ptParam <= lastParam ? args[ptParam].asString() : null)) || "conventional".equalsIgnoreCase(op)) {
            String stype;
            String string = stype = ++ptParam > lastParam ? "" : args[ptParam].asString().toUpperCase();
            if (stype.equals("BCC")) {
                stype = "I";
            } else if (stype.length() == 0) {
                stype = (String)this.vwr.getSymTemp().getSymmetryInfoAtom(this.vwr.ms, iatom, null, 0, null, null, null, 0x400000AA, 0.0f, -1);
            }
            if (stype == null || stype.length() == 0 || !(u == null ? this.vwr.getSymTemp() : u).toFromPrimitive(toPrimitive, stype.charAt(0), (T3[])ucnew)) {
                return false;
            }
        } else if ("reciprocal".equalsIgnoreCase(op)) {
            ucnew = SimpleUnitCell.getReciprocal((T3[])ucnew, null, (float)scale);
            scale = 1.0f;
        }
        if (scale != 1.0f) {
            for (int i = 1; i < 4; ++i) {
                ucnew[i].scale(scale);
            }
        }
        return mp.addXObj((Object)ucnew);
    }

    private boolean evaluateArray(ScriptMathProcessor mp, SV[] args, boolean isSelector) throws ScriptException {
        if (isSelector) {
            SV x1 = mp.getX();
            switch (args.length == 1 ? x1.tok : 0) {
                case 6: {
                    int i;
                    Lst lst = new Lst();
                    String id = args[0].asString();
                    Map map = x1.getMap();
                    String[] keys = x1.getKeys(false);
                    int n = keys.length;
                    for (i = 0; i < n; ++i) {
                        if (((SV)map.get(keys[i])).getMap() != null) continue;
                        return false;
                    }
                    n = keys.length;
                    for (i = 0; i < n; ++i) {
                        SV m = (SV)map.get(keys[i]);
                        Map m1 = m.getMap();
                        Map m2 = (Map)SV.deepCopy((Object)m1, (boolean)true, (boolean)false);
                        m2.put(id, SV.newS((String)keys[i]));
                        lst.addLast((Object)SV.newV((int)6, (Object)m2));
                    }
                    return mp.addXList(lst);
                }
                case 7: {
                    int i;
                    Hashtable<String, SV> map1 = new Hashtable<String, SV>();
                    Lst lst1 = x1.getList();
                    String id1 = args[0].asString();
                    int n = lst1.size();
                    for (i = 0; i < n; ++i) {
                        Map m0 = ((SV)lst1.get(i)).getMap();
                        if (m0 != null && m0.get(id1) != null) continue;
                        return false;
                    }
                    n = lst1.size();
                    for (i = 0; i < n; ++i) {
                        SV m = (SV)lst1.get(i);
                        Map m1 = (Map)SV.deepCopy((Object)m.getMap(), (boolean)true, (boolean)false);
                        SV mid = (SV)m1.remove(id1);
                        map1.put(mid.asString(), SV.newV((int)6, (Object)m1));
                    }
                    return mp.addXObj(map1);
                }
            }
            return false;
        }
        SV[] a = new SV[args.length];
        int i = a.length;
        while (--i >= 0) {
            a[i] = SV.newT((T)args[i]);
        }
        return mp.addXAV(a);
    }

    private boolean evaluateBin(ScriptMathProcessor mp, SV[] args) throws ScriptException {
        float[] data;
        boolean isListf;
        int n = args.length;
        if (n < 3 || n > 5) {
            return false;
        }
        SV x1 = mp.getX();
        boolean bl = isListf = x1.tok == 13;
        if (!isListf && x1.tok != 7) {
            return mp.addX(x1);
        }
        float f0 = SV.fValue((T)args[0]);
        float f1 = SV.fValue((T)args[1]);
        float df = SV.fValue((T)args[2]);
        boolean addBins = n >= 4 && args[n - 1].tok == 1073742335;
        String key = (n == 5 || n == 4 && !addBins) && args[3].tok != 1073742334 ? SV.sValue((T)args[3]) : null;
        Map[] maps = null;
        if (isListf) {
            data = (float[])x1.value;
        } else {
            Lst list = x1.getList();
            data = new float[list.size()];
            if (key != null) {
                maps = AU.createArrayOfHashtable((int)list.size());
            }
            try {
                int i = list.size();
                while (--i >= 0) {
                    SV sV;
                    if (key == null) {
                        sV = (SV)list.get(i);
                    } else {
                        maps[i] = ((SV)list.get(i)).getMap();
                        sV = (SV)maps[i].get(key);
                    }
                    data[i] = SV.fValue((T)sV);
                }
            }
            catch (Exception e) {
                return false;
            }
        }
        int nbins = Math.max((int)Math.floor((f1 - f0) / df + 0.01f), 1);
        int[] array = new int[nbins];
        int nPoints = data.length;
        for (int i = 0; i < nPoints; ++i) {
            Map map;
            float v = data[i];
            int bin = (int)Math.floor((v - f0) / df);
            if (bin < 0 || bin >= nbins) continue;
            int n2 = bin;
            array[n2] = array[n2] + 1;
            if (key == null || (map = maps[i]) == null) continue;
            map.put("_bin", SV.newI((int)bin));
            float v1 = f0 + df * (float)bin;
            float v2 = v1 + df;
            map.put("_binMin", SV.newF((float)(bin == 0 ? -3.4028235E38f : v1)));
            map.put("_binMax", SV.newF((float)(bin == nbins - 1 ? Float.MAX_VALUE : v2)));
        }
        if (addBins) {
            Lst lst = new Lst();
            for (int i = 0; i < nbins; ++i) {
                lst.addLast((Object)new float[]{f0 + df * (float)i, array[i]});
            }
            return mp.addXList(lst);
        }
        return mp.addXAI(array);
    }

    private boolean evaluateCache(ScriptMathProcessor mp, SV[] args) {
        if (args.length > 0) {
            return false;
        }
        return mp.addXMap(this.vwr.fm.cacheList());
    }

    private boolean evaluateColor(ScriptMathProcessor mp, SV[] args) {
        boolean haveRange;
        ColorEncoder ce;
        String colorScheme = args.length > 0 ? SV.sValue((T)args[0]) : "";
        boolean isIsosurface = colorScheme.startsWith("$");
        if (args.length == 2 && colorScheme.equalsIgnoreCase("TOHSL")) {
            return mp.addXPt(CU.rgbToHSL((P3)P3.newP((T3)(args[1].tok == 8 ? SV.ptValue((SV)args[1]) : CU.colorPtFromString((String)args[1].asString()))), (boolean)true));
        }
        if (args.length == 2 && colorScheme.equalsIgnoreCase("TORGB")) {
            P3 pt = P3.newP((T3)(args[1].tok == 8 ? SV.ptValue((SV)args[1]) : CU.colorPtFromString((String)args[1].asString())));
            return mp.addXPt(args[1].tok == 8 ? CU.hslToRGB((P3)pt) : pt);
        }
        if (args.length == 4 && (args[3].tok == 1073742335 || args[3].tok == 1073742334)) {
            boolean usingHSL;
            P3 pt1 = P3.newP((T3)(args[0].tok == 8 ? SV.ptValue((SV)args[0]) : CU.colorPtFromString((String)args[0].asString())));
            P3 pt2 = P3.newP((T3)(args[1].tok == 8 ? SV.ptValue((SV)args[1]) : CU.colorPtFromString((String)args[1].asString())));
            boolean bl = usingHSL = args[3].tok == 1073742335;
            if (usingHSL) {
                pt1 = CU.rgbToHSL((P3)pt1, (boolean)false);
                pt2 = CU.rgbToHSL((P3)pt2, (boolean)false);
            }
            SB sb = new SB();
            V3 vd = V3.newVsub((T3)pt2, (T3)pt1);
            int n = args[2].asInt();
            if (n < 2) {
                n = 20;
            }
            vd.scale(1.0f / (float)(n - 1));
            for (int i = 0; i < n; ++i) {
                sb.append(Escape.escapeColor((int)CU.colorPtToFFRGB((T3)(usingHSL ? CU.hslToRGB((P3)pt1) : pt1))));
                pt1.add((T3)vd);
            }
            return mp.addXStr(sb.toString());
        }
        ColorEncoder colorEncoder = ce = isIsosurface ? null : this.vwr.cm.getColorEncoder(colorScheme);
        if (!isIsosurface && ce == null) {
            return mp.addXStr("");
        }
        float lo = args.length > 1 ? SV.fValue((T)args[1]) : Float.MAX_VALUE;
        float hi = args.length > 2 ? SV.fValue((T)args[2]) : Float.MAX_VALUE;
        float value = args.length > 3 ? SV.fValue((T)args[3]) : Float.MAX_VALUE;
        boolean getValue = value != Float.MAX_VALUE || lo != Float.MAX_VALUE && hi == Float.MAX_VALUE;
        boolean bl = haveRange = hi != Float.MAX_VALUE;
        if (!haveRange && colorScheme.length() == 0) {
            value = lo;
            float[] range = this.vwr.getCurrentColorRange();
            lo = range[0];
            hi = range[1];
        }
        if (isIsosurface) {
            String id = colorScheme.substring(1);
            Object[] data = new Object[]{id, null};
            if (!this.vwr.shm.getShapePropertyData(24, "colorEncoder", data)) {
                return mp.addXStr("");
            }
            ce = (ColorEncoder)data[1];
        } else {
            ce.setRange(lo, hi, lo > hi);
        }
        Map key = ce.getColorKey();
        if (getValue) {
            return mp.addXPt(CU.colorPtFromInt((int)ce.getArgb(hi == Float.MAX_VALUE ? lo : value), null));
        }
        return mp.addX(SV.getVariableMap((Map)key));
    }

    private boolean evaluateCompare(ScriptMathProcessor mp, SV[] args) throws ScriptException {
        if (args.length < 2 || args.length > 5) {
            return false;
        }
        String sOpt = SV.sValue((T)args[args.length - 1]);
        boolean isStdDev = sOpt.equalsIgnoreCase("stddev");
        boolean isIsomer = sOpt.equalsIgnoreCase("ISOMER");
        boolean isBonds = sOpt.equalsIgnoreCase("BONDS");
        boolean isSmiles = !isIsomer && args.length > (isStdDev ? 3 : 2);
        BS bs1 = args[0].tok == 10 ? (BS)args[0].value : null;
        BS bs2 = args[1].tok == 10 ? (BS)args[1].value : null;
        String smiles1 = bs1 == null ? SV.sValue((T)args[0]) : "";
        String smiles2 = bs2 == null ? SV.sValue((T)args[1]) : "";
        M4 m = new M4();
        float stddev = Float.NaN;
        try {
            if (isSmiles && (bs1 == null || bs2 == null)) {
                return false;
            }
            if (isBonds) {
                if (args.length != 4) {
                    return false;
                }
                smiles1 = SV.sValue((T)args[2]);
                isSmiles = smiles1.equalsIgnoreCase("SMILES");
                try {
                    if (isSmiles) {
                        smiles1 = this.vwr.getSmiles(bs1);
                    }
                }
                catch (Exception ex) {
                    this.e.evalError(ex.getMessage(), null);
                }
                float[] data = this.e.getSmilesExt().getFlexFitList(bs1, bs2, smiles1, !isSmiles);
                return data == null ? mp.addXStr("") : mp.addXAF(data);
            }
            if (isIsomer) {
                boolean check;
                String mf2;
                if (args.length != 3) {
                    return false;
                }
                if (bs1 == null && bs2 == null) {
                    return mp.addXStr(this.vwr.getSmilesMatcher().getRelationship(smiles1, smiles2).toUpperCase());
                }
                String mf1 = bs1 == null ? this.vwr.getSmilesMatcher().getMolecularFormula(smiles1, false) : JmolMolecule.getMolecularFormulaAtoms((Node[])this.vwr.ms.at, (BS)bs1, null, (boolean)false);
                String string = mf2 = bs2 == null ? this.vwr.getSmilesMatcher().getMolecularFormula(smiles2, false) : JmolMolecule.getMolecularFormulaAtoms((Node[])this.vwr.ms.at, (BS)bs2, null, (boolean)false);
                if (!mf1.equals(mf2)) {
                    return mp.addXStr("NONE");
                }
                if (bs1 != null) {
                    smiles1 = (String)this.e.getSmilesExt().getSmilesMatches("/strict///", null, bs1, null, 1, true, false);
                }
                if (bs2 == null) {
                    check = this.vwr.getSmilesMatcher().areEqual(smiles2, smiles1) > 0;
                } else {
                    smiles2 = (String)this.e.getSmilesExt().getSmilesMatches("/strict///", null, bs2, null, 1, true, false);
                    boolean bl = check = ((BS)this.e.getSmilesExt().getSmilesMatches("/strict///" + smiles1, null, bs2, null, 1, true, false)).nextSetBit(0) >= 0;
                }
                if (!check) {
                    String s = smiles1 + smiles2;
                    if (s.indexOf("/") >= 0 || s.indexOf("\\") >= 0 || s.indexOf("@") >= 0) {
                        if (smiles1.indexOf("@") >= 0 && (bs2 != null || smiles2.indexOf("@") >= 0) && smiles1.indexOf("@SP") < 0) {
                            int pt = smiles1.toLowerCase().indexOf("invertstereo");
                            String string2 = smiles1 = pt >= 0 ? "/strict/" + smiles1.substring(0, pt) + smiles1.substring(pt + 12) : "/invertstereo strict/" + smiles1;
                            if (bs2 == null) {
                                check = this.vwr.getSmilesMatcher().areEqual(smiles1, smiles2) > 0;
                            } else {
                                boolean bl = check = ((BS)this.e.getSmilesExt().getSmilesMatches(smiles1, null, bs2, null, 1, true, false)).nextSetBit(0) >= 0;
                            }
                            if (check) {
                                return mp.addXStr("ENANTIOMERS");
                            }
                        }
                        if (bs2 == null) {
                            check = this.vwr.getSmilesMatcher().areEqual("/nostereo/" + smiles2, smiles1) > 0;
                        } else {
                            Object ret = this.e.getSmilesExt().getSmilesMatches("/nostereo/" + smiles1, null, bs2, null, 1, true, false);
                            boolean bl = check = ((BS)ret).nextSetBit(0) >= 0;
                        }
                        if (check) {
                            return mp.addXStr("DIASTEREOMERS");
                        }
                    }
                    return mp.addXStr("CONSTITUTIONAL ISOMERS");
                }
                if (bs1 == null || bs2 == null) {
                    return mp.addXStr("IDENTICAL");
                }
                stddev = this.e.getSmilesExt().getSmilesCorrelation(bs1, bs2, smiles1, null, null, null, null, false, null, null, false, 1);
                return mp.addXStr(stddev < 0.2f ? "IDENTICAL" : "IDENTICAL or CONFORMATIONAL ISOMERS (RMSD=" + stddev + ")");
            }
            if (isSmiles) {
                boolean bestMap;
                boolean isSearch;
                Lst ptsA = new Lst();
                Lst ptsB = new Lst();
                sOpt = SV.sValue((T)args[2]);
                boolean isMap = sOpt.equalsIgnoreCase("MAP");
                isSmiles = sOpt.equalsIgnoreCase("SMILES");
                boolean bl = isSearch = isMap || sOpt.equalsIgnoreCase("SMARTS");
                if (isSmiles || isSearch) {
                    sOpt = args.length > (isStdDev ? 4 : 3) ? SV.sValue((T)args[3]) : null;
                }
                boolean hMaps = "H".equalsIgnoreCase(sOpt) || "allH".equalsIgnoreCase(sOpt) || "bestH".equalsIgnoreCase(sOpt);
                boolean isPolyhedron = "polyhedra".equalsIgnoreCase(sOpt);
                if (isPolyhedron) {
                    sOpt = args.length > (isStdDev ? 5 : 4) ? SV.sValue((T)args[4]) : null;
                }
                boolean allMaps = "all".equalsIgnoreCase(sOpt) || "allH".equalsIgnoreCase(sOpt);
                boolean bl2 = bestMap = "best".equalsIgnoreCase(sOpt) || "bestH".equalsIgnoreCase(sOpt);
                if ("stddev".equals(sOpt)) {
                    sOpt = null;
                }
                String pattern = sOpt;
                if (sOpt == null || hMaps || allMaps || bestMap) {
                    if (!isMap && !isSmiles || hMaps && isPolyhedron) {
                        return false;
                    }
                    pattern = "/noaromatic" + (allMaps || bestMap ? "/" : " nostereo/") + this.e.getSmilesExt().getSmilesMatches(hMaps ? "H" : "", null, bs1, null, 1, true, false);
                } else {
                    allMaps = true;
                }
                stddev = this.e.getSmilesExt().getSmilesCorrelation(bs1, bs2, pattern, (Lst<P3>)ptsA, (Lst<P3>)ptsB, m, null, isMap, null, null, bestMap, (isSmiles ? 1 : 2) | (!allMaps && !bestMap ? 8 : 0));
                if (isMap) {
                    int nAtoms = ptsA.size();
                    if (nAtoms == 0) {
                        return mp.addXStr("");
                    }
                    int nMatch = ptsB.size() / nAtoms;
                    Lst ret = new Lst();
                    int pt = 0;
                    for (int i = 0; i < nMatch; ++i) {
                        int[][] a = AU.newInt2((int)nAtoms);
                        ret.addLast((Object)a);
                        int j = 0;
                        while (j < nAtoms) {
                            a[j] = new int[]{((Atom)ptsA.get((int)j)).i, ((Atom)ptsB.get((int)pt)).i};
                            ++j;
                            ++pt;
                        }
                    }
                    return allMaps ? mp.addXList(ret) : (ret.size() > 0 ? mp.addXAII((int[][])ret.get(0)) : mp.addXStr(""));
                }
            } else {
                switch (args.length) {
                    case 2: {
                        break;
                    }
                    case 3: {
                        if (isStdDev) break;
                    }
                    default: {
                        return false;
                    }
                }
                Lst ptsA = this.e.getPointVector((T)args[0], 0);
                Lst ptsB = this.e.getPointVector((T)args[1], 0);
                if (ptsA != null && ptsB != null) {
                    Interface.getInterface((String)"javajs.util.Eigen", (Viewer)this.vwr, (String)"script");
                    stddev = Measure.getTransformMatrix4((Lst)ptsA, (Lst)ptsB, (M4)m, null);
                }
            }
            return isStdDev || Float.isNaN(stddev) ? mp.addXFloat(stddev) : mp.addXM4(m.round(1.0E-7f));
        }
        catch (Exception ex) {
            this.e.evalError(ex.getMessage() == null ? ex.toString() : ex.getMessage(), null);
            return false;
        }
    }

    private boolean evaluateConnected(ScriptMathProcessor mp, SV[] args, int tok, int intValue) throws ScriptException {
        if (args.length > 5) {
            return false;
        }
        float min = -2.1474836E9f;
        float max = 2.1474836E9f;
        float fmin = 0.0f;
        float fmax = Float.MAX_VALUE;
        int order = 65535;
        BS atoms1 = null;
        BS atoms2 = null;
        boolean haveDecimal = false;
        boolean isBonds = false;
        switch (tok) {
            case 1275203608: {
                Object[] data;
                int nv = Integer.MIN_VALUE;
                String smiles = null;
                if (args.length > 0) {
                    switch (args[0].tok) {
                        case 2: {
                            nv = args[0].intValue;
                            break;
                        }
                        case 4: {
                            smiles = SV.sValue((T)args[0]);
                        }
                    }
                }
                if (intValue == 1275203608) {
                    atoms1 = SV.getBitSet((SV)mp.getX(), (boolean)true);
                }
                if (!this.vwr.shm.getShapePropertyData(21, "getCenters", data = new Object[]{nv, smiles, atoms1})) {
                    data[1] = null;
                }
                return mp.addXBs(data[1] == null ? new BS() : (BS)data[1]);
            }
            case 1228931587: {
                SV x1 = mp.getX();
                if (x1.tok != 10 || args.length != 1 || args[0].tok != 10) {
                    return false;
                }
                atoms1 = (BS)x1.value;
                atoms2 = (BS)args[0].value;
                Lst list = new Lst();
                Atom[] atoms = this.vwr.ms.at;
                int i = atoms1.nextSetBit(0);
                while (i >= 0) {
                    int n = 0;
                    Bond[] b = atoms[i].bonds;
                    int j = b.length;
                    while (--j >= 0) {
                        if (!atoms2.get(b[j].getOtherAtom((Atom)atoms[i]).i)) continue;
                        ++n;
                    }
                    list.addLast((Object)n);
                    i = atoms1.nextSetBit(i + 1);
                }
                return mp.addXList(list);
            }
        }
        block15: for (int i = 0; i < args.length; ++i) {
            SV var = args[i];
            switch (var.tok) {
                case 10: {
                    isBonds = var.value instanceof BondSet;
                    if (isBonds && atoms1 != null) {
                        return false;
                    }
                    if (atoms1 == null) {
                        atoms1 = (BS)var.value;
                        continue block15;
                    }
                    if (atoms2 == null) {
                        atoms2 = (BS)var.value;
                        continue block15;
                    }
                    return false;
                }
                case 4: {
                    String type = SV.sValue((T)var);
                    order = type.equalsIgnoreCase("hbond") ? 30720 : ScriptParam.getBondOrderFromString((String)type);
                    if (order != 131071) continue block15;
                    return false;
                }
                case 3: {
                    haveDecimal = true;
                }
                default: {
                    int n = var.asInt();
                    float f = var.asFloat();
                    if (max != 2.1474836E9f) {
                        return false;
                    }
                    if (min == -2.1474836E9f) {
                        min = Math.max(n, 0);
                        fmin = f;
                        continue block15;
                    }
                    max = n;
                    fmax = f;
                }
            }
        }
        if (min == -2.1474836E9f) {
            min = 1.0f;
            max = 100.0f;
            fmin = 0.1f;
            fmax = 1.0E8f;
        } else if (max == 2.1474836E9f) {
            max = min;
            fmax = fmin;
            fmin = 0.1f;
        }
        if (atoms1 == null) {
            atoms1 = this.vwr.getAllAtoms();
        }
        if (haveDecimal && atoms2 == null) {
            atoms2 = atoms1;
        }
        if (atoms2 != null) {
            BS bsBonds = new BS();
            this.vwr.makeConnections(fmin, fmax, order, 1086324745, atoms1, atoms2, bsBonds, isBonds, false, 0.0f);
            return mp.addX(SV.newV((int)10, (Object)BondSet.newBS((BS)bsBonds, (int[])this.vwr.ms.getAtomIndices(this.vwr.ms.getAtoms(1677721602, (Object)bsBonds)))));
        }
        return mp.addXBs(this.vwr.ms.getAtomsConnected(min, max, order, atoms1));
    }

    private boolean evaluateContact(ScriptMathProcessor mp, SV[] args) {
        if (args.length < 1 || args.length > 3) {
            return false;
        }
        int i = 0;
        float distance = 100.0f;
        int tok = args[0].tok;
        switch (tok) {
            case 2: 
            case 3: {
                distance = SV.fValue((T)args[i++]);
                break;
            }
            case 10: {
                break;
            }
            default: {
                return false;
            }
        }
        if (i == args.length || !(args[i].value instanceof BS)) {
            return false;
        }
        BS bsA = BSUtil.copy((BS)((BS)args[i++].value));
        BS bsB = i < args.length ? BSUtil.copy((BS)((BS)args[i].value)) : null;
        RadiusData rd = new RadiusData(null, distance > 10.0f ? distance / 100.0f : distance, distance > 10.0f ? RadiusData.EnumType.FACTOR : RadiusData.EnumType.OFFSET, VDW.AUTO);
        bsB = this.setContactBitSets(bsA, bsB, true, Float.NaN, rd, false);
        bsB.or(bsA);
        return mp.addXBs(bsB);
    }

    private boolean evaluateData(ScriptMathProcessor mp, SV[] args) {
        String selected = args.length == 0 ? "" : SV.sValue((T)args[0]);
        String type = "";
        switch (args.length) {
            case 0: 
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                if (args[0].tok != 10) break;
                return mp.addXStr(this.vwr.getModelFileData(selected, SV.sValue((T)args[1]), args.length == 3 && SV.bValue((T)args[2])));
            }
            case 4: {
                int iField = args[1].asInt();
                int nBytes = args[2].asInt();
                int firstLine = args[3].asInt();
                float[] f = Parser.parseFloatArrayFromMatchAndField((String)SV.sValue((T)args[0]), null, (int)0, (int)0, null, (int)iField, (int)nBytes, null, (int)firstLine);
                return mp.addXStr(Escape.escapeFloatA((float[])f, (boolean)false));
            }
            default: {
                return false;
            }
        }
        if (selected.indexOf("data2d_") == 0) {
            float[][] f1 = (float[][])this.vwr.getDataObj(selected, null, 2);
            if (f1 == null) {
                return mp.addXStr("");
            }
            if (args.length == 2 && args[1].tok == 2) {
                int pt = args[1].intValue;
                if (pt < 0) {
                    pt += f1.length;
                }
                if (pt >= 0 && pt < f1.length) {
                    return mp.addXStr(Escape.escapeFloatA((float[])f1[pt], (boolean)false));
                }
                return mp.addXStr("");
            }
            return mp.addXStr(Escape.escapeFloatAA((float[][])f1, (boolean)false));
        }
        if (selected.indexOf("property_") == 0) {
            float[] f2;
            float[] f1 = (float[])this.vwr.getDataObj(selected, null, 1);
            if (f1 == null) {
                return mp.addXStr("");
            }
            float[] fArray = f2 = type.indexOf("property_") == 0 ? (float[])this.vwr.getDataObj(selected, null, 1) : null;
            if (f2 != null) {
                f1 = AU.arrayCopyF((float[])f1, (int)-1);
                int i = Math.min(f1.length, f2.length);
                while (--i >= 0) {
                    int n = i;
                    f1[n] = f1[n] + f2[i];
                }
            }
            return mp.addXStr(Escape.escapeFloatA((float[])f1, (boolean)false));
        }
        Object[] data = (Object[])this.vwr.getDataObj(selected, null, -1);
        return mp.addXStr(data == null ? "" : "" + data[1]);
    }

    private boolean evaluateDotDist(ScriptMathProcessor mp, SV[] args, int tok, int op) throws ScriptException {
        float f;
        block33: {
            SV x2;
            SV x1;
            boolean isDist = tok == 1275069443;
            SV x3 = null;
            switch (args.length) {
                case 2: {
                    if (op == Integer.MAX_VALUE) {
                        x1 = args[0];
                        x2 = args[1];
                        break;
                    }
                    x3 = args[1];
                }
                case 1: {
                    x1 = mp.getX();
                    x2 = args[0];
                    break;
                }
                default: {
                    return false;
                }
            }
            if (tok == 1275069442) {
                P3 a = P3.newP((T3)mp.ptValue(x1, null));
                a.cross((T3)a, (T3)mp.ptValue(x2, null));
                return mp.addXPt(a);
            }
            P3 pt2 = x2.tok == 7 ? null : mp.ptValue(x2, null);
            P4 plane2 = mp.planeValue((T)x2);
            if (isDist) {
                int minMax = op == Integer.MIN_VALUE ? 0 : op & 0x1E0;
                boolean isMinMax = minMax == 32 || minMax == 64;
                boolean isAll = minMax == 480;
                switch (x1.tok) {
                    case 10: {
                        BS bs = (BS)x1.value;
                        BS bs2 = null;
                        boolean returnAtom = isMinMax && x3 != null && x3.asBoolean();
                        switch (x2.tok) {
                            case 10: {
                                bs2 = x2.tok == 10 ? (BS)x2.value : null;
                            }
                            case 8: {
                                Atom[] atoms = this.vwr.ms.at;
                                if (returnAtom) {
                                    float dMinMax = Float.NaN;
                                    int iMinMax = Integer.MAX_VALUE;
                                    int i = bs.nextSetBit(0);
                                    while (i >= 0) {
                                        float d;
                                        float f2 = d = bs2 == null ? atoms[i].distanceSquared((T3)pt2) : ((Float)this.e.getBitsetProperty(bs2, op, (P3)atoms[i], plane2, x1.value, null, false, x1.index, false)).floatValue();
                                        if (!(minMax == 32 ? d >= dMinMax : d <= dMinMax)) {
                                            dMinMax = d;
                                            iMinMax = i;
                                        }
                                        i = bs.nextSetBit(i + 1);
                                    }
                                    return mp.addXBs(iMinMax == Integer.MAX_VALUE ? new BS() : BSUtil.newAndSetBit((int)iMinMax));
                                }
                                if (isAll) {
                                    if (bs2 == null) {
                                        float[] data = new float[bs.cardinality()];
                                        int p = 0;
                                        int i = bs.nextSetBit(0);
                                        while (i >= 0) {
                                            data[p] = atoms[i].distance((T3)pt2);
                                            i = bs.nextSetBit(i + 1);
                                            ++p;
                                        }
                                        return mp.addXAF(data);
                                    }
                                    float[][] data2 = new float[bs.cardinality()][bs2.cardinality()];
                                    int p = 0;
                                    int i = bs.nextSetBit(0);
                                    while (i >= 0) {
                                        int q = 0;
                                        int j = bs2.nextSetBit(0);
                                        while (j >= 0) {
                                            data2[p][q] = atoms[i].distance((T3)atoms[j]);
                                            j = bs2.nextSetBit(j + 1);
                                            ++q;
                                        }
                                        i = bs.nextSetBit(i + 1);
                                        ++p;
                                    }
                                    return mp.addXAFF(data2);
                                }
                                if (isMinMax) {
                                    float[] data = new float[bs.cardinality()];
                                    int i = bs.nextSetBit(0);
                                    int p = 0;
                                    while (i >= 0) {
                                        data[p++] = ((Float)this.e.getBitsetProperty(bs2, op, (P3)atoms[i], plane2, x1.value, null, false, x1.index, false)).floatValue();
                                        i = bs.nextSetBit(i + 1);
                                    }
                                    return mp.addXAF(data);
                                }
                                return mp.addXObj(this.e.getBitsetProperty(bs, op, pt2, plane2, x1.value, null, false, x1.index, false));
                            }
                        }
                    }
                }
            }
            P3 pt1 = mp.ptValue(x1, null);
            P4 plane1 = mp.planeValue((T)x1);
            f = Float.NaN;
            try {
                if (isDist) {
                    if (plane2 != null && x3 != null) {
                        f = Measure.directedDistanceToPlane((P3)pt1, (P4)plane2, (P3)SV.ptValue((SV)x3));
                        break block33;
                    }
                    f = plane1 == null ? (plane2 == null ? pt2.distance((T3)pt1) : Measure.distanceToPlane((P4)plane2, (T3)pt1)) : Measure.distanceToPlane((P4)plane1, (T3)pt2);
                    break block33;
                }
                if (plane1 != null && plane2 != null) {
                    f = plane1.x * plane2.x + plane1.y * plane2.y + plane1.z * plane2.z + plane1.w * plane2.w;
                } else {
                    if (plane1 != null) {
                        pt1 = P3.new3((float)plane1.x, (float)plane1.y, (float)plane1.z);
                    } else if (plane2 != null) {
                        pt2 = P3.new3((float)plane2.x, (float)plane2.y, (float)plane2.z);
                    }
                    f = pt1.dot((T3)pt2);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return mp.addXFloat(f);
    }

    private boolean evaluateHelix(ScriptMathProcessor mp, SV[] args) throws ScriptException {
        if (args.length < 1 || args.length > 5) {
            return false;
        }
        int pt = args.length > 2 ? 3 : 1;
        String type = pt >= args.length ? "array" : SV.sValue((T)args[pt]);
        int tok = T.getTokFromName((String)type);
        if (args.length > 2) {
            P3 pta = mp.ptValue(args[0], null);
            P3 ptb = mp.ptValue(args[1], null);
            if (tok == 0 || args[2].tok != 9 || pta == null || ptb == null) {
                return false;
            }
            Quat dq = Quat.newP4((P4)((P4)args[2].value));
            T3[] data = Measure.computeHelicalAxis((P3)pta, (P3)ptb, (Quat)dq);
            return data == null ? false : mp.addXObj(Escape.escapeHelical((String)type, (int)tok, (P3)pta, (P3)ptb, (T3[])data));
        }
        BS bs = args[0].value instanceof BS ? (BS)args[0].value : this.vwr.ms.getAtoms(1094715412, (Object)new Integer(args[0].asInt()));
        switch (tok) {
            case 134217751: 
            case 1073741854: 
            case 1665140738: {
                return mp.addXObj(this.getHelixData(bs, tok));
            }
            case 0x8000001: {
                return mp.addXFloat(((Float)this.getHelixData(bs, 0x8000001)).floatValue());
            }
            case 135176: 
            case 1745489939: {
                return mp.addXObj(this.getHelixData(bs, tok));
            }
            case 1275068418: {
                String[] data = (String[])this.getHelixData(bs, 1073742001);
                if (data == null) {
                    return false;
                }
                return mp.addXAS(data);
            }
        }
        return false;
    }

    private Object getHelixData(BS bs, int tokType) {
        int iAtom = bs.nextSetBit(0);
        return iAtom < 0 ? "null" : this.vwr.ms.at[iAtom].group.getHelixData(tokType, this.vwr.getQuaternionFrame(), this.vwr.getInt(0x21000012));
    }

    private boolean evaluateFind(ScriptMathProcessor mp, SV[] args) throws ScriptException {
        boolean isPattern;
        boolean isSequence;
        String flags;
        String sFind;
        boolean isEmpty;
        boolean isList;
        SV x1;
        block52: {
            boolean isSeq;
            x1 = mp.getX();
            isList = x1.tok == 7;
            isEmpty = args.length == 0;
            sFind = isEmpty ? "" : SV.sValue((T)args[0]);
            flags = args.length > 1 && args[1].tok != 1073742335 && args[1].tok != 1073742334 && args[1].tok != 10 ? SV.sValue((T)args[1]) : "";
            isSequence = !isList && sFind.equalsIgnoreCase("SEQUENCE");
            boolean bl = isSeq = !isList && sFind.equalsIgnoreCase("SEQ");
            if (sFind.toUpperCase().startsWith("SMILES/")) {
                String s;
                if (!sFind.endsWith("/")) {
                    sFind = sFind + "/";
                }
                if (JC.isSmilesCanonical((String)(s = sFind.substring(6) + "//"))) {
                    flags = "SMILES";
                    sFind = "CHEMICAL";
                } else {
                    sFind = "SMILES";
                    flags = s + flags;
                }
            } else if (sFind.toUpperCase().startsWith("SMARTS/")) {
                if (!sFind.endsWith("/")) {
                    sFind = sFind + "/";
                }
                flags = sFind.substring(6) + (flags.length() == 0 ? "//" : flags);
                sFind = "SMARTS";
            }
            boolean isSmiles = !isList && sFind.equalsIgnoreCase("SMILES");
            boolean isSMARTS = !isList && sFind.equalsIgnoreCase("SMARTS");
            boolean isChemical = !isList && sFind.equalsIgnoreCase("CHEMICAL");
            boolean isMF = !isList && sFind.equalsIgnoreCase("MF");
            boolean isCF = !isList && sFind.equalsIgnoreCase("CELLFORMULA");
            SV argLast = args.length > 0 ? args[args.length - 1] : SV.vF;
            boolean isON = !isList && argLast.tok == 1073742335;
            try {
                if (isChemical) {
                    BS bsAtoms = x1.tok == 10 ? (BS)x1.value : null;
                    String data = bsAtoms == null ? SV.sValue((T)x1) : this.vwr.getOpenSmiles(bsAtoms);
                    if ((data = (data.length() == 0 ? "" : this.vwr.getChemicalInfo(data, flags.toLowerCase(), bsAtoms)).trim()).startsWith("InChI")) {
                        data = PT.rep((String)PT.rep((String)data, (String)"InChI=", (String)""), (String)"InChIKey=", (String)"");
                    }
                    return mp.addXStr(data);
                }
                if (!isSmiles && !isSMARTS && x1.tok != 10) break block52;
                int iPt = isSmiles || isSMARTS ? 2 : 1;
                BS bs2 = iPt < args.length && args[iPt].tok == 10 ? (BS)args[iPt++].value : null;
                boolean asBonds = "bonds".equalsIgnoreCase(SV.sValue((T)args[args.length - 1]));
                boolean isAll = asBonds || isON;
                Object ret = null;
                switch (x1.tok) {
                    case 4: {
                        String smiles = SV.sValue((T)x1);
                        if (bs2 != null || isSmiles && args.length == 1) {
                            return false;
                        }
                        if (flags.equalsIgnoreCase("mf")) {
                            ret = this.vwr.getSmilesMatcher().getMolecularFormula(smiles, isSMARTS);
                            break;
                        }
                        String pattern = flags;
                        boolean allMappings = true;
                        boolean asMap = false;
                        switch (args.length) {
                            case 4: {
                                allMappings = SV.bValue((T)args[3]);
                            }
                            case 3: {
                                asMap = SV.bValue((T)args[2]);
                            }
                        }
                        boolean justOne = !asMap && (!allMappings || !isSMARTS);
                        try {
                            ret = this.e.getSmilesExt().getSmilesMatches(pattern, smiles, null, null, isSMARTS ? 2 : 1, !asMap, !allMappings);
                        }
                        catch (Exception ex) {
                            System.out.println(ex.getMessage());
                            return mp.addXInt(-1);
                        }
                        if (!justOne) break;
                        int len = ((int[])ret).length;
                        return mp.addXInt(!allMappings && len > 0 ? 1 : len);
                    }
                    case 10: {
                        BS bs = (BS)x1.value;
                        if (isMF && flags.length() != 0) {
                            return mp.addXBs(JmolMolecule.getBitSetForMF((Atom[])this.vwr.ms.at, (BS)bs, (String)flags));
                        }
                        if (isMF || isCF) {
                            return mp.addXStr(JmolMolecule.getMolecularFormulaAtoms((Node[])this.vwr.ms.at, (BS)bs, isMF ? null : this.vwr.ms.getCellWeights(bs), (boolean)isON));
                        }
                        if (isSequence || isSeq) {
                            boolean isHH = argLast.asString().equalsIgnoreCase("H");
                            return mp.addXStr(this.vwr.getSmilesOpt(bs, -1, -1, ((isAll |= isHH) ? 0x700000 | (isHH ? 0x900000 : 0) : 0) | (isSeq ? 0x2100000 : 0x100000), null));
                        }
                        if (isSmiles || isSMARTS) {
                            sFind = args.length > 1 && args[1].tok == 10 ? this.vwr.getSmilesOpt((BS)args[1].value, 0, 0, 0, flags) : flags;
                        }
                        flags = flags.toUpperCase();
                        BS bsMatch3D = bs2;
                        if (asBonds) {
                            int[][] map = this.vwr.getSmilesMatcher().getCorrelationMaps(sFind, (Node[])this.vwr.ms.at, this.vwr.ms.ac, bs, (isSmiles ? 1 : 2) | 8);
                            ret = map.length > 0 ? (Object)this.vwr.ms.getDihedralMap(map[0]) : new int[]{};
                            break;
                        }
                        if (flags.equalsIgnoreCase("map")) {
                            int[][] map = this.vwr.getSmilesMatcher().getCorrelationMaps(sFind, (Node[])this.vwr.ms.at, this.vwr.ms.ac, bs, (isSmiles ? 1 : 2) | 0x80);
                            ret = map;
                            break;
                        }
                        if (sFind.equalsIgnoreCase("crystalClass")) {
                            ret = this.vwr.ms.generateCrystalClass(bs.nextSetBit(0), args.length != 2 ? null : (argLast.tok == 10 ? this.vwr.ms.getAtomSetCenter((BS)argLast.value) : SV.ptValue((SV)argLast)));
                            break;
                        }
                        int smilesFlags = (isSmiles ? (flags.indexOf("OPEN") >= 0 ? 5 : 1) : 2) | (isON && sFind.length() == 0 ? 0x1500000 : 0);
                        ret = this.e.getSmilesExt().getSmilesMatches(sFind, null, bs, bsMatch3D, smilesFlags, !isON, false);
                    }
                }
                if (ret == null) {
                    this.e.invArg();
                }
                return mp.addXObj(ret);
            }
            catch (Exception ex) {
                this.e.evalError(ex.getMessage(), null);
            }
        }
        boolean isReverse = flags.indexOf("v") >= 0;
        boolean isCaseInsensitive = flags.indexOf("i") >= 0;
        boolean asMatch = flags.indexOf("m") >= 0;
        boolean checkEmpty = sFind.length() == 0;
        boolean bl = isPattern = !checkEmpty && args.length == 2;
        if (isList || isPattern) {
            int i;
            int nlist;
            Lst svlist;
            JmolPatternMatcher pm = isPattern ? this.getPatternMatcher() : null;
            Pattern pattern = null;
            Lst lst = svlist = isList ? x1.getList() : null;
            if (isPattern) {
                try {
                    pattern = pm.compile(sFind, isCaseInsensitive);
                }
                catch (Exception ex) {
                    this.e.evalError(ex.toString(), null);
                }
            }
            String[] list = checkEmpty ? null : SV.strListValue((T)x1);
            int n = nlist = checkEmpty ? svlist.size() : list.length;
            if (Logger.debugging) {
                Logger.debug((String)("finding " + sFind));
            }
            BS bs = new BS();
            int n2 = 0;
            Matcher matcher = null;
            Lst v = asMatch ? new Lst() : null;
            String what = "";
            for (int i2 = 0; i2 < nlist; ++i2) {
                boolean isMatch;
                if (checkEmpty) {
                    SV o = (SV)svlist.get(i2);
                    switch (o.tok) {
                        case 6: {
                            isMatch = o.getMap().isEmpty() != isEmpty;
                            break;
                        }
                        case 7: {
                            isMatch = o.getList().size() == 0 != isEmpty;
                            break;
                        }
                        case 4: {
                            isMatch = o.asString().length() == 0 != isEmpty;
                            break;
                        }
                        default: {
                            isMatch = true;
                            break;
                        }
                    }
                } else if (isPattern) {
                    what = list[i2];
                    matcher = pattern.matcher(what);
                    isMatch = matcher.find();
                } else {
                    boolean bl2 = isMatch = SV.sValue((T)((T)svlist.get(i2))).indexOf(sFind) >= 0;
                }
                if ((!asMatch || !isMatch) && (asMatch || isMatch != !isReverse)) continue;
                ++n2;
                bs.set(i2);
                if (!asMatch) continue;
                v.addLast((Object)(isReverse ? what.substring(0, matcher.start()) + what.substring(matcher.end()) : matcher.group()));
            }
            if (!isList) {
                return asMatch ? mp.addXStr(v.size() == 1 ? (String)v.get(0) : "") : (isReverse ? mp.addXBool(n2 == 1) : (asMatch ? mp.addXStr(n2 == 0 ? "" : matcher.group()) : mp.addXInt(n2 == 0 ? 0 : matcher.start() + 1)));
            }
            if (asMatch) {
                String[] listNew = new String[n2];
                if (n2 > 0) {
                    i = list.length;
                    while (--i >= 0) {
                        if (!bs.get(i)) continue;
                        String string = asMatch ? (String)v.get(--n2) : list[i];
                        listNew[n2] = string;
                    }
                }
                return mp.addXAS(listNew);
            }
            Lst l = new Lst();
            i = bs.nextSetBit(0);
            while (i >= 0) {
                l.addLast(svlist.get(i));
                i = bs.nextSetBit(i + 1);
            }
            return mp.addXList(l);
        }
        if (isSequence) {
            return mp.addXStr(this.vwr.getJBR().toStdAmino3(SV.sValue((T)x1)));
        }
        return mp.addXInt(SV.sValue((T)x1).indexOf(sFind) + 1);
    }

    private boolean evaluateGetProperty(ScriptMathProcessor mp, SV[] args, int tok0, boolean isAtomProperty) throws ScriptException {
        String pname;
        int tok;
        boolean isSelect = isAtomProperty && tok0 == 1275082245;
        boolean isAuxiliary = tok0 == 1275068449;
        int pt = 0;
        int n = tok = args.length == 0 ? 0 : args[0].tok;
        if (args.length == 2 && (tok == 7 || tok == 6 || tok == 14)) {
            return mp.addXObj(this.vwr.extractProperty(args[0].value, (Object)args[1].value.toString(), -1));
        }
        BS bsSelect = isAtomProperty && args.length == 1 && args[0].tok == 10 ? (BS)args[0].value : null;
        String propertyName = pname = bsSelect == null && args.length > 0 ? SV.sValue((T)args[pt++]) : "";
        String lc = propertyName.toLowerCase();
        if (!isSelect && lc.indexOf("[select ") < 0) {
            propertyName = lc;
        }
        boolean isJSON = false;
        if (propertyName.equals("json") && args.length > pt) {
            isJSON = true;
            propertyName = SV.sValue((T)args[pt++]);
        }
        SV x = null;
        if (isAtomProperty) {
            x = mp.getX();
            switch (x.tok) {
                case 10: {
                    break;
                }
                case 4: {
                    String name = (String)x.value;
                    Object[] data = new Object[3];
                    if (name.startsWith("$")) {
                        int shapeID = this.vwr.shm.getShapeIdFromObjectName(name = name.substring(1));
                        if (shapeID >= 0) {
                            data[0] = name;
                            this.vwr.shm.getShapePropertyData(shapeID, "index", data);
                            if (data[1] != null && !pname.equals("index")) {
                                int index = (Integer)data[1];
                                data[1] = this.vwr.shm.getShapePropertyIndex(shapeID, pname.intern(), index);
                            }
                        }
                    } else {
                        int shapeID = JC.shapeTokenIndex((int)T.getTokFromName((String)name));
                        if (shapeID >= 0) {
                            data[0] = pname;
                            data[1] = -1;
                            this.vwr.shm.getShapePropertyData(shapeID, pname.intern(), data);
                        }
                    }
                    return data[1] == null ? mp.addXStr("") : mp.addXObj(data[1]);
                }
                case 7: {
                    if (bsSelect != null) {
                        Lst l0 = x.getList();
                        Lst lst = new Lst();
                        int i = bsSelect.nextSetBit(0);
                        while (i >= 0) {
                            lst.addLast(l0.get(i));
                            i = bsSelect.nextSetBit(i + 1);
                        }
                        return mp.addXList(lst);
                    }
                }
                default: {
                    if (isSelect) {
                        propertyName = "[SELECT " + propertyName + "]";
                    }
                    return mp.addXObj(this.vwr.extractProperty((Object)x, (Object)propertyName, -1));
                }
            }
            if (!lc.startsWith("bondinfo") && !lc.startsWith("atominfo")) {
                propertyName = "atomInfo." + propertyName;
            }
        }
        BS[] propertyValue = "";
        if (propertyName.equalsIgnoreCase("fileContents") && args.length > 2) {
            String s = SV.sValue((T)args[1]);
            for (int i = 2; i < args.length; ++i) {
                s = s + "|" + SV.sValue((T)args[i]);
            }
            propertyValue = s;
            pt = args.length;
        } else if (args.length > pt) {
            switch (args[pt].tok) {
                case 10: {
                    propertyValue = args[pt++].value;
                    if (!propertyName.equalsIgnoreCase("bondInfo") || args.length <= pt || args[pt].tok != 10) break;
                    propertyValue = new BS[]{(BS)propertyValue, (BS)args[pt].value};
                    break;
                }
                case 4: 
                case 6: {
                    if (!this.vwr.checkPropertyParameter(propertyName)) break;
                    propertyValue = args[pt++].value;
                }
            }
        }
        if (isAtomProperty) {
            BS bs = (BS)x.value;
            int iAtom = bs.nextSetBit(0);
            if (iAtom < 0) {
                return mp.addXStr("");
            }
            propertyValue = bs;
        }
        if (isAuxiliary && !isAtomProperty) {
            propertyName = "auxiliaryInfo.models." + propertyName;
        }
        propertyName = PT.rep((String)propertyName, (String)".[", (String)"[");
        Object property = this.vwr.getProperty(null, propertyName, (Object)propertyValue);
        if (pt < args.length) {
            property = this.vwr.extractProperty(property, (Object)args, pt);
        }
        return mp.addXObj(isJSON ? SV.safeJSON((String)"value", (Object)property) : (SV.isVariableType((Object)property) ? property : Escape.toReadable((String)propertyName, (Object)property)));
    }

    private boolean evaluateFormat(ScriptMathProcessor mp, int intValue, SV[] args, boolean isLabel) throws ScriptException {
        Lst formatList;
        Lst listIn;
        String format;
        SV x1;
        Object object = x1 = args.length < 2 || intValue == 1287653388 ? mp.getX() : null;
        String string = args.length == 0 ? "%U" : (format = args[0].tok == 7 ? null : SV.sValue((T)args[0]));
        if (!isLabel && args.length > 0 && x1 != null && x1.tok != 10 && format != null) {
            if (args.length == 2) {
                listIn = x1.getList();
                formatList = args[1].getList();
                if (listIn == null || formatList == null) {
                    return false;
                }
                x1 = SV.getVariableList(this.getSublist((Lst<SV>)listIn, (Lst<SV>)formatList));
            }
            args = new SV[]{args[0], x1};
            x1 = null;
        }
        if (x1 == null) {
            int pt;
            int n = pt = isLabel ? -1 : SV.getFormatType((String)format);
            if (pt >= 0 && args.length != 2) {
                return false;
            }
            if (pt >= 0 || args.length < 2 || args[1].tok != 7) {
                Object o = SV.format((SV[])args, (int)pt);
                return format.equalsIgnoreCase("json") ? mp.addXStr((String)o) : mp.addXObj(o);
            }
            Lst a = args[1].getList();
            SV[] args2 = new SV[]{args[0], null};
            String[] sa = new String[a.size()];
            int i = sa.length;
            while (--i >= 0) {
                args2[1] = (SV)a.get(i);
                sa[i] = SV.format((SV[])args2, (int)pt).toString();
            }
            return mp.addXAS(sa);
        }
        if (x1.tok == 7 && format == null) {
            listIn = x1.getList();
            formatList = args[0].getList();
            Lst<SV> listOut = this.getSublist((Lst<SV>)listIn, (Lst<SV>)formatList);
            return mp.addXList(listOut);
        }
        BS bs = x1.tok == 10 ? (BS)x1.value : null;
        boolean asArray = T.tokAttr((int)intValue, (int)480);
        return mp.addXObj(format == null ? "" : (bs == null ? SV.sprintf((String)PT.formatCheck((String)format), (SV)x1) : this.e.getCmdExt().getBitsetIdent(bs, format, x1.value, true, x1.index, asArray)));
    }

    private Lst<SV> getSublist(Lst<SV> listIn, Lst<SV> formatList) {
        Lst listOut = new Lst();
        int n = listIn.size();
        block4: for (int i = 0; i < n; ++i) {
            SV element = (SV)listIn.get(i);
            switch (element.tok) {
                case 6: {
                    int j;
                    Hashtable<String, Object> map = element.getMap();
                    Lst list = new Lst();
                    int n1 = formatList.size();
                    for (j = 0; j < n1; ++j) {
                        SV v = (SV)map.get(SV.sValue((T)((T)formatList.get(j))));
                        list.addLast((Object)(v == null ? SV.newS((String)"") : v));
                    }
                    listOut.addLast((Object)SV.getVariableList((Lst)list));
                    continue block4;
                }
                case 7: {
                    int j;
                    Hashtable<String, Object> map = new Hashtable<String, Object>();
                    Lst list = element.getList();
                    int n1 = Math.min(list.size(), formatList.size());
                    for (j = 0; j < n1; ++j) {
                        map.put(SV.sValue((T)((T)formatList.get(j))), list.get(j));
                    }
                    listOut.addLast((Object)SV.getVariable(map));
                }
            }
        }
        return listOut;
    }

    private boolean evaluateList(ScriptMathProcessor mp, int tok, SV[] args) throws ScriptException {
        boolean isAll;
        int len = args.length;
        SV x1 = mp.getX();
        boolean isArray1 = x1.tok == 7;
        switch (tok) {
            case 1275335685: {
                return len == 2 && mp.addX(x1.pushPop(args[1], args[0])) || len == 1 && mp.addX(x1.pushPop(args[0], null));
            }
            case 1275334681: {
                return len == 1 && mp.addX(x1.pushPop(null, args[0])) || len == 0 && mp.addX(x1.pushPop(null, null));
            }
            case 1275069441: {
                if (len == 1 || len == 2) break;
                return false;
            }
            case 1275069446: 
            case 1275069447: {
                break;
            }
            default: {
                if (len == 1) break;
                return false;
            }
        }
        String[] sList1 = null;
        String[] sList2 = null;
        String[] sList3 = null;
        if (len == 2) {
            boolean isCSV;
            String tab = SV.sValue((T)args[0]);
            SV x2 = args[1];
            if (tok == 1275069441) {
                sList1 = isArray1 ? SV.strListValue((T)x1) : PT.split((String)SV.sValue((T)x1), (String)"\n");
                sList2 = x2.tok == 7 ? SV.strListValue((T)x2) : PT.split((String)SV.sValue((T)x2), (String)"\n");
                len = Math.max(sList1.length, sList2.length);
                sList3 = new String[len];
                for (int i = 0; i < len; ++i) {
                    sList3[i] = (i >= sList1.length ? "" : sList1[i]) + tab + (i >= sList2.length ? "" : sList2[i]);
                }
                return mp.addXAS(sList3);
            }
            if (x2.tok != 1073742335) {
                return false;
            }
            Lst l = x1.getList();
            boolean bl = isCSV = tab.length() == 0;
            if (isCSV) {
                tab = ",";
            }
            if (tok == 1275069446) {
                SV[] s2 = new SV[l.size()];
                int i = l.size();
                while (--i >= 0) {
                    Lst a = ((SV)l.get(i)).getList();
                    if (a == null) {
                        s2[i] = (SV)l.get(i);
                        continue;
                    }
                    SB sb = new SB();
                    int n = a.size();
                    for (int j = 0; j < n; ++j) {
                        if (j > 0) {
                            sb.append(tab);
                        }
                        SV sv = (SV)a.get(j);
                        sb.append(isCSV && sv.tok == 4 ? "\"" + PT.rep((String)((String)sv.value), (String)"\"", (String)"\"\"") + "\"" : "" + sv.asString());
                    }
                    s2[i] = SV.newS((String)sb.toString());
                }
                return mp.addXAV(s2);
            }
            Lst sa = new Lst();
            if (isCSV) {
                tab = "\u0000";
            }
            int[] next = new int[2];
            int nl = l.size();
            for (int i = 0; i < nl; ++i) {
                String line = ((SV)l.get(i)).asString();
                if (isCSV) {
                    next[1] = 0;
                    next[0] = 0;
                    int last = 0;
                    while (true) {
                        String s;
                        if ((s = PT.getCSVString((String)line, (int[])next)) == null) {
                            if (next[1] == -1) {
                                line = line + (++i < nl ? "\n" + ((SV)l.get(i)).asString() : "\"");
                                next[1] = last;
                                continue;
                            }
                            line = line.substring(0, last) + line.substring(last).replace(',', '\u0000');
                            break;
                        }
                        line = line.substring(0, last) + line.substring(last, next[0]).replace(',', '\u0000') + s + line.substring(next[1]);
                        next[1] = last = next[0] + s.length();
                    }
                }
                String[] linaa = line.split(tab);
                Lst la = new Lst();
                for (String s : linaa) {
                    if (s.indexOf(".") < 0) {
                        try {
                            la.addLast((Object)SV.newI((int)Integer.parseInt(s)));
                            continue;
                        }
                        catch (Exception e) {
                        }
                    } else {
                        try {
                            la.addLast((Object)SV.getVariable((Object)Float.valueOf(Float.parseFloat(s))));
                            continue;
                        }
                        catch (Exception ee) {
                            // empty catch block
                        }
                    }
                    la.addLast((Object)SV.newS((String)s));
                }
                sa.addLast((Object)SV.getVariableList((Lst)la));
            }
            return mp.addXObj((Object)SV.getVariableList((Lst)sa));
        }
        SV x2 = len == 0 ? SV.newV((int)1073742327, (Object)"all") : args[0];
        boolean bl = isAll = x2.tok == 1073742327;
        if (!isArray1 && x1.tok != 4) {
            return mp.binaryOp(this.opTokenFor(tok), x1, x2);
        }
        boolean isScalar1 = SV.isScalar((SV)x1);
        boolean isScalar2 = SV.isScalar((SV)x2);
        float[] list1 = null;
        float[] list2 = null;
        Lst alist1 = x1.getList();
        Lst alist2 = x2.getList();
        if (isArray1) {
            len = alist1.size();
        } else if (isScalar1) {
            len = Integer.MAX_VALUE;
        } else {
            sList1 = PT.split((String)SV.sValue((T)x1), (String)"\n");
            len = sList1.length;
            list1 = new float[len];
            PT.parseFloatArrayData((String[])sList1, (float[])list1);
        }
        if (isAll && tok != 1275069446) {
            float sum = 0.0f;
            if (isArray1) {
                int i = len;
                while (--i >= 0) {
                    sum += SV.fValue((T)((T)alist1.get(i)));
                }
            } else if (!isScalar1) {
                int i = len;
                while (--i >= 0) {
                    sum += list1[i];
                }
            }
            return mp.addXFloat(sum);
        }
        if (tok == 1275069446 && x2.tok == 4) {
            SB sb = new SB();
            if (isScalar1) {
                sb.append(SV.sValue((T)x1));
            } else {
                String s = isAll ? "" : x2.value.toString();
                for (int i = 0; i < len; ++i) {
                    sb.append(i > 0 ? s : "").append(SV.sValue((T)((T)alist1.get(i))));
                }
            }
            return mp.addXStr(sb.toString());
        }
        SV scalar = null;
        if (isScalar2) {
            scalar = x2;
        } else if (x2.tok == 7) {
            len = Math.min(len, alist2.size());
        } else {
            sList2 = PT.split((String)SV.sValue((T)x2), (String)"\n");
            list2 = new float[sList2.length];
            PT.parseFloatArrayData((String[])sList2, (float[])list2);
            len = Math.min(len, list2.length);
        }
        T token = this.opTokenFor(tok);
        SV[] olist = new SV[len];
        if (isArray1 && isAll) {
            Lst llist = new Lst();
            return mp.addXList(this.addAllLists((Lst<SV>)x1.getList(), (Lst<SV>)llist));
        }
        SV a = isScalar1 ? x1 : null;
        for (int i = 0; i < len; ++i) {
            SV b = isScalar2 ? scalar : (x2.tok == 7 ? (SV)alist2.get(i) : (Float.isNaN(list2[i]) ? SV.getVariable((Object)SV.unescapePointOrBitsetAsVariable((Object)sList2[i])) : SV.newF((float)list2[i])));
            if (!isScalar1) {
                a = isArray1 ? (SV)alist1.get(i) : (Float.isNaN(list1[i]) ? SV.getVariable((Object)SV.unescapePointOrBitsetAsVariable((Object)sList1[i])) : SV.newF((float)list1[i]));
            }
            if (tok == 1275069446 && a.tok != 7) {
                Lst l = new Lst();
                l.addLast((Object)a);
                a = SV.getVariableList((Lst)l);
            }
            if (!mp.binaryOp(token, a, b)) {
                return false;
            }
            olist[i] = mp.getX();
        }
        return mp.addXAV(olist);
    }

    private Lst<SV> addAllLists(Lst<SV> list, Lst<SV> l) {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            SV v = (SV)list.get(i);
            if (v.tok == 7) {
                this.addAllLists((Lst<SV>)v.getList(), l);
                continue;
            }
            l.addLast((Object)v);
        }
        return l;
    }

    private boolean evaluateLoad(ScriptMathProcessor mp, SV[] args, boolean isFile) throws ScriptException {
        String file;
        int nBytesMax = -1;
        boolean asBytes = false;
        boolean async = this.vwr.async;
        switch (args.length) {
            case 3: {
                async = SV.bValue((T)args[2]);
            }
            case 2: {
                nBytesMax = args[1].tok == 2 ? args[1].asInt() : -1;
                asBytes = args[1].tok == 1073742335;
            }
            case 1: {
                file = FileManager.fixDOSName((String)SV.sValue((T)args[0]));
                break;
            }
            default: {
                return false;
            }
        }
        if (asBytes) {
            return mp.addXMap(this.vwr.fm.getFileAsMap(file));
        }
        boolean isQues = file.startsWith("?");
        if (this.vwr.isJS && (isQues || async)) {
            if (isFile && isQues) {
                return mp.addXStr("");
            }
            file = this.e.loadFileAsync("load()_", file, mp.oPt, true);
        }
        return mp.addXStr(isFile ? this.vwr.fm.getFilePath(file, false, false) : this.vwr.getFileAsString4(file, nBytesMax, false, false, true, "script"));
    }

    private boolean evaluateMath(ScriptMathProcessor mp, SV[] args, int tok) {
        if (tok == 134217749) {
            if (args.length == 1 && args[0].tok == 4) {
                return mp.addXStr(new Date() + "\t" + SV.sValue((T)args[0]));
            }
            return mp.addXInt(((int)System.currentTimeMillis() & Integer.MAX_VALUE) - (args.length == 0 ? 0 : args[0].asInt()));
        }
        if (args.length != 1) {
            return false;
        }
        if (tok == 134218250) {
            if (args[0].tok == 2) {
                return mp.addXInt(Math.abs(args[0].asInt()));
            }
            return mp.addXFloat(Math.abs(args[0].asFloat()));
        }
        double x = SV.fValue((T)args[0]);
        switch (tok) {
            case 0x8000202: {
                return mp.addXFloat((float)(Math.acos(x) * 180.0 / Math.PI));
            }
            case 134218245: {
                return mp.addXFloat((float)Math.cos(x * Math.PI / 180.0));
            }
            case 134218244: {
                return mp.addXFloat((float)Math.sin(x * Math.PI / 180.0));
            }
            case 134218246: {
                return mp.addXFloat((float)Math.sqrt(x));
            }
        }
        return false;
    }

    private boolean evaluateMeasure(ScriptMathProcessor mp, SV[] args, int tok) throws ScriptException {
        int nPoints = 0;
        switch (tok) {
            case 1745489939: {
                Lst points = new Lst();
                float[] rangeMinMax = new float[]{Float.MAX_VALUE, Float.MAX_VALUE};
                String strFormat = null;
                String units = null;
                boolean isAllConnected = false;
                boolean isNotConnected = false;
                int rPt = 0;
                boolean isNull = false;
                RadiusData rd = null;
                int nBitSets = 0;
                float vdw = Float.MAX_VALUE;
                boolean asMinArray = false;
                boolean asArray = false;
                block15: for (int i = 0; i < args.length; ++i) {
                    switch (args[i].tok) {
                        case 10: {
                            BS bs = (BS)args[i].value;
                            if (bs.length() == 0) {
                                isNull = true;
                            }
                            points.addLast((Object)bs);
                            ++nPoints;
                            ++nBitSets;
                            continue block15;
                        }
                        case 8: {
                            Point3fi v = new Point3fi();
                            v.setT((T3)((P3)args[i].value));
                            points.addLast((Object)v);
                            ++nPoints;
                            continue block15;
                        }
                        case 2: 
                        case 3: {
                            rangeMinMax[rPt++ % 2] = SV.fValue((T)args[i]);
                            continue block15;
                        }
                        case 4: {
                            String s = SV.sValue((T)args[i]);
                            if (s.equalsIgnoreCase("vdw") || s.equalsIgnoreCase("vanderwaals")) {
                                vdw = (float)(i + 1 < args.length && args[i + 1].tok == 2 ? args[++i].asInt() : 100) / 100.0f;
                                continue block15;
                            }
                            if (s.equalsIgnoreCase("notConnected")) {
                                isNotConnected = true;
                                continue block15;
                            }
                            if (s.equalsIgnoreCase("connected")) {
                                isAllConnected = true;
                                continue block15;
                            }
                            if (s.equalsIgnoreCase("minArray")) {
                                asMinArray = nBitSets >= 1;
                                continue block15;
                            }
                            if (s.equalsIgnoreCase("asArray")) {
                                asArray = nBitSets >= 1;
                                continue block15;
                            }
                            if (PT.isOneOf((String)s.toLowerCase(), (String)";nm;nanometers;pm;picometers;angstroms;ang;au;") || s.endsWith("hz")) {
                                units = s.toLowerCase();
                                continue block15;
                            }
                            strFormat = nPoints + ":" + s;
                            continue block15;
                        }
                        default: {
                            return false;
                        }
                    }
                }
                if (nPoints < 2 || nPoints > 4 || rPt > 2 || isNotConnected && isAllConnected) {
                    return false;
                }
                if (isNull) {
                    return mp.addXStr("");
                }
                if (vdw != Float.MAX_VALUE && (nBitSets != 2 || nPoints != 2)) {
                    return mp.addXStr("");
                }
                rd = vdw == Float.MAX_VALUE ? new RadiusData(rangeMinMax, 0.0f, null, null) : new RadiusData(null, vdw, RadiusData.EnumType.FACTOR, VDW.AUTO);
                return mp.addXObj(this.vwr.newMeasurementData(null, points).set(0, null, rd, strFormat, units, null, isAllConnected, isNotConnected, null, true, 0, (short)0, null).getMeasurements(asArray, asMinArray));
            }
            case 0x8000001: {
                nPoints = args.length;
                if (nPoints == 3 || nPoints == 4) break;
                return false;
            }
            default: {
                nPoints = args.length;
                if (nPoints == 2) break;
                return false;
            }
        }
        P3[] pts = new P3[nPoints];
        for (int i = 0; i < nPoints; ++i) {
            pts[i] = mp.ptValue(args[i], null);
            if (pts[i] != null) continue;
            return false;
        }
        switch (nPoints) {
            case 2: {
                return mp.addXFloat(pts[0].distance((T3)pts[1]));
            }
            case 3: {
                return mp.addXFloat(Measure.computeAngleABC((T3)pts[0], (T3)pts[1], (T3)pts[2], (boolean)true));
            }
            case 4: {
                return mp.addXFloat(Measure.computeTorsion((T3)pts[0], (T3)pts[1], (T3)pts[2], (T3)pts[3], (boolean)true));
            }
        }
        return false;
    }

    private boolean evaluateModulation(ScriptMathProcessor mp, SV[] args) throws ScriptException {
        String type = "";
        float t = Float.NaN;
        P3 t456 = null;
        block0 : switch (args.length) {
            case 0: {
                break;
            }
            case 1: {
                switch (args[0].tok) {
                    case 8: {
                        t456 = (P3)args[0].value;
                        break block0;
                    }
                    case 4: {
                        type = args[0].asString();
                        break block0;
                    }
                }
                t = SV.fValue((T)args[0]);
                break;
            }
            case 2: {
                type = SV.sValue((T)args[0]);
                t = SV.fValue((T)args[1]);
                break;
            }
            default: {
                return false;
            }
        }
        if (t456 == null && (double)t < 1000000.0) {
            t456 = P3.new3((float)t, (float)t, (float)t);
        }
        SV x = mp.getX();
        BS bs = x.tok == 10 ? (BS)x.value : new BS();
        return mp.addXList(this.vwr.ms.getModulationList(bs, (type + "D").toUpperCase().charAt(0), t456));
    }

    private boolean evaluatePlane(ScriptMathProcessor mp, SV[] args, int tok) throws ScriptException {
        block33: {
            if (tok == 134219265 && args.length != 3 || tok == 134219266 && args.length != 2 && args.length != 3 || args.length == 0 || args.length > 4) {
                return false;
            }
            switch (args.length) {
                case 1: {
                    BS bs;
                    if (args[0].tok == 10 && (bs = (BS)args[0].value).cardinality() == 3) {
                        Lst pts = this.vwr.ms.getAtomPointVector(bs);
                        return mp.addXPt4(Measure.getPlaneThroughPoints((T3)((T3)pts.get(0)), (T3)((T3)pts.get(1)), (T3)((T3)pts.get(2)), (V3)new V3(), (V3)new V3(), (P4)new P4()));
                    }
                    Object pt = Escape.uP((String)SV.sValue((T)args[0]));
                    if (pt instanceof P4) {
                        return mp.addXPt4((P4)pt);
                    }
                    return mp.addXStr("" + pt);
                }
                case 2: {
                    if (tok == 134219266) {
                        if (args[1].tok != 9) {
                            return false;
                        }
                        P3 pt3 = new P3();
                        V3 norm = new V3();
                        V3 vTemp = new V3();
                        P4 plane = (P4)args[1].value;
                        if (args[0].tok == 9) {
                            Lst list = Measure.getIntersectionPP((P4)((P4)args[0].value), (P4)plane);
                            if (list == null) {
                                return mp.addXStr("");
                            }
                            return mp.addXList(list);
                        }
                        P3 pt2 = mp.ptValue(args[0], null);
                        if (pt2 == null) {
                            return mp.addXStr("");
                        }
                        return mp.addXPt(Measure.getIntersection((P3)pt2, null, (P4)plane, (P3)pt3, (V3)norm, (V3)vTemp));
                    }
                }
                case 3: 
                case 4: {
                    switch (tok) {
                        case 134219265: {
                            return mp.addXPt4(this.e.getHklPlane(P3.new3((float)SV.fValue((T)args[0]), (float)SV.fValue((T)args[1]), (float)SV.fValue((T)args[2]))));
                        }
                        case 134219266: {
                            P3 pt1 = mp.ptValue(args[0], null);
                            P3 pt2 = mp.ptValue(args[1], null);
                            if (pt1 == null || pt2 == null) {
                                return mp.addXStr("");
                            }
                            V3 vLine = V3.newV((T3)pt2);
                            vLine.normalize();
                            if (args[2].tok == 9) {
                                P3 pt3 = new P3();
                                V3 norm = new V3();
                                V3 vTemp = new V3();
                                if ((pt1 = Measure.getIntersection((P3)pt1, (V3)vLine, (P4)((P4)args[2].value), (P3)pt3, (V3)norm, (V3)vTemp)) == null) {
                                    return mp.addXStr("");
                                }
                                return mp.addXPt(pt1);
                            }
                            P3 pt3 = mp.ptValue(args[2], null);
                            if (pt3 == null) {
                                return mp.addXStr("");
                            }
                            V3 v = new V3();
                            Measure.projectOntoAxis((P3)pt3, (P3)pt1, (V3)vLine, (V3)v);
                            return mp.addXPt(pt3);
                        }
                    }
                    switch (args[0].tok) {
                        case 2: 
                        case 3: {
                            if (args.length == 3) {
                                float r = SV.fValue((T)args[0]);
                                float theta = SV.fValue((T)args[1]);
                                float phi = SV.fValue((T)args[2]);
                                V3 norm = V3.new3((float)0.0f, (float)0.0f, (float)1.0f);
                                P3 pt2 = P3.new3((float)0.0f, (float)1.0f, (float)0.0f);
                                Quat q = Quat.newVA((T3)pt2, (float)phi);
                                q.getMatrix().rotate((T3)norm);
                                pt2.set(0.0f, 0.0f, 1.0f);
                                q = Quat.newVA((T3)pt2, (float)theta);
                                q.getMatrix().rotate((T3)norm);
                                pt2.setT((T3)norm);
                                pt2.scale(r);
                                P4 plane = new P4();
                                Measure.getPlaneThroughPoint((T3)pt2, (V3)norm, (P4)plane);
                                return mp.addXPt4(plane);
                            }
                            break block33;
                        }
                        case 8: 
                        case 10: {
                            P3 pt1 = mp.ptValue(args[0], null);
                            P3 pt2 = mp.ptValue(args[1], null);
                            if (pt2 == null) {
                                return false;
                            }
                            P3 pt3 = args.length > 2 && (args[2].tok == 10 || args[2].tok == 8) ? mp.ptValue(args[2], null) : null;
                            V3 norm = V3.newV((T3)pt2);
                            if (pt3 == null) {
                                P4 plane = new P4();
                                if (args.length == 2 || args[2].tok != 2 && args[2].tok != 3 && !args[2].asBoolean()) {
                                    pt3 = P3.newP((T3)pt1);
                                    pt3.add((T3)pt2);
                                    pt3.scale(0.5f);
                                    norm.sub((T3)pt1);
                                    norm.normalize();
                                } else if (args[2].tok == 1073742335) {
                                    pt3 = pt1;
                                } else {
                                    norm.sub((T3)pt1);
                                    pt3 = new P3();
                                    pt3.scaleAdd2(args[2].asFloat(), (T3)norm, (T3)pt1);
                                }
                                Measure.getPlaneThroughPoint((T3)pt3, (V3)norm, (P4)plane);
                                return mp.addXPt4(plane);
                            }
                            V3 vAB = new V3();
                            P3 ptref = args.length == 4 ? mp.ptValue(args[3], null) : null;
                            float nd = Measure.getDirectedNormalThroughPoints((T3)pt1, (T3)pt2, (T3)pt3, (T3)ptref, (V3)norm, (V3)vAB);
                            return mp.addXPt4(P4.new4((float)norm.x, (float)norm.y, (float)norm.z, (float)nd));
                        }
                    }
                }
            }
        }
        if (args.length != 4) {
            return false;
        }
        float x = SV.fValue((T)args[0]);
        float y = SV.fValue((T)args[1]);
        float z = SV.fValue((T)args[2]);
        float w = SV.fValue((T)args[3]);
        return mp.addXPt4(P4.new4((float)x, (float)y, (float)z, (float)w));
    }

    private boolean evaluatePoint(ScriptMathProcessor mp, SV[] args) {
        switch (args.length) {
            default: {
                return false;
            }
            case 1: {
                Object pt;
                if (args[0].tok == 3 || args[0].tok == 2) {
                    return mp.addXInt(args[0].asInt());
                }
                String s = SV.sValue((T)args[0]);
                if (args[0].tok == 7) {
                    s = "{" + s + "}";
                }
                return (pt = Escape.uP((String)s)) instanceof P3 ? mp.addXPt((P3)pt) : mp.addXStr("" + pt);
            }
            case 2: {
                P3 pt3;
                switch (args[1].tok) {
                    case 1073742334: 
                    case 1073742335: {
                        switch (args[0].tok) {
                            case 8: {
                                pt3 = P3.newP((T3)((T3)args[0].value));
                                break;
                            }
                            case 10: {
                                pt3 = this.vwr.ms.getAtomSetCenter((BS)args[0].value);
                                break;
                            }
                            default: {
                                return false;
                            }
                        }
                        if (args[1].tok == 1073742335) {
                            this.vwr.tm.transformPt3f((T3)pt3, pt3);
                            pt3.y = (float)this.vwr.tm.height - pt3.y;
                            if (!this.vwr.antialiased) break;
                            pt3.scale(0.5f);
                            break;
                        }
                        if (this.vwr.antialiased) {
                            pt3.scale(2.0f);
                        }
                        pt3.y = (float)this.vwr.tm.height - pt3.y;
                        this.vwr.tm.unTransformPoint((T3)pt3, (T3)pt3);
                        break;
                    }
                    case 8: {
                        Lst sv = args[0].getList();
                        if (sv == null || sv.size() != 4) {
                            return false;
                        }
                        P3 pt1 = SV.ptValue((SV)args[1]);
                        pt3 = P3.newP((T3)SV.ptValue((SV)((SV)sv.get(0))));
                        pt3.scaleAdd2(pt1.x, (T3)SV.ptValue((SV)((SV)sv.get(1))), (T3)pt3);
                        pt3.scaleAdd2(pt1.y, (T3)SV.ptValue((SV)((SV)sv.get(2))), (T3)pt3);
                        pt3.scaleAdd2(pt1.z, (T3)SV.ptValue((SV)((SV)sv.get(3))), (T3)pt3);
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                return mp.addXPt(pt3);
            }
            case 3: {
                return mp.addXPt(P3.new3((float)args[0].asFloat(), (float)args[1].asFloat(), (float)args[2].asFloat()));
            }
            case 4: 
        }
        return mp.addXPt4(P4.new4((float)args[0].asFloat(), (float)args[1].asFloat(), (float)args[2].asFloat(), (float)args[3].asFloat()));
    }

    private boolean evaluatePrompt(ScriptMathProcessor mp, SV[] args) {
        boolean asButtons;
        if (args.length != 1 && args.length != 2 && args.length != 3) {
            return false;
        }
        String label = SV.sValue((T)args[0]);
        String[] buttonArray = args.length > 1 && args[1].tok == 7 ? SV.strListValue((T)args[1]) : null;
        boolean bl = asButtons = buttonArray != null || args.length == 1 || args.length == 3 && args[2].asBoolean();
        String input = buttonArray != null ? null : (args.length >= 2 ? SV.sValue((T)args[1]) : "OK");
        String s = "" + this.vwr.prompt(label, input, buttonArray, asButtons);
        return asButtons && buttonArray != null ? mp.addXInt(Integer.parseInt(s) + 1) : mp.addXStr(s);
    }

    private boolean evaluateQuaternion(ScriptMathProcessor mp, SV[] args, int tok) throws ScriptException {
        P3 pt0 = null;
        int nArgs = args.length;
        int nMax = Integer.MAX_VALUE;
        boolean isRelative = false;
        if (tok == 134221850) {
            if (nArgs > 1 && args[nArgs - 1].tok == 4 && ((String)args[nArgs - 1].value).equalsIgnoreCase("relative")) {
                --nArgs;
                isRelative = true;
            }
            if (nArgs > 1 && args[nArgs - 1].tok == 2 && args[0].tok == 10) {
                nMax = args[nArgs - 1].asInt();
                if (nMax <= 0) {
                    nMax = 0x7FFFFFFE;
                }
                --nArgs;
            }
        }
        switch (nArgs) {
            case 0: 
            case 1: 
            case 4: {
                break;
            }
            case 2: {
                if (tok == 134221850 && (args[0].tok == 7 && (args[1].tok == 7 || args[1].tok == 1073742335) || args[0].tok == 10 && (args[1].tok == 2 || args[1].tok == 10)) || (pt0 = mp.ptValue(args[0], null)) != null && (tok == 134221850 || args[1].tok != 8)) break;
                return false;
            }
            case 3: {
                if (tok != 134221850) {
                    return false;
                }
                if (args[0].tok == 9) {
                    if (args[2].tok == 8 || args[2].tok == 10) break;
                    return false;
                }
                for (int i = 0; i < 3; ++i) {
                    if (args[i].tok == 8 || args[i].tok == 10) continue;
                    return false;
                }
                break;
            }
            default: {
                return false;
            }
        }
        Quat q = null;
        Quat[] qs = null;
        P4 p4 = null;
        switch (nArgs) {
            case 0: {
                return mp.addXPt4(this.vwr.tm.getRotationQ().toPoint4f());
            }
            default: {
                Quat[] data1;
                if (tok == 134221850 && args[0].tok == 7) {
                    data1 = this.e.getQuaternionArray((Object)args[0].getList(), 1073742001);
                    Quat mean = Quat.sphereMean((Quat[])data1, null, (float)1.0E-4f);
                    q = mean instanceof Quat ? mean : null;
                    break;
                }
                if (tok == 134221850 && args[0].tok == 10) {
                    qs = this.vwr.getAtomGroupQuaternions((BS)args[0].value, nMax);
                } else if (args[0].tok == 11) {
                    q = Quat.newM((M3)((M3)args[0].value));
                } else if (args[0].tok == 9) {
                    p4 = (P4)args[0].value;
                } else {
                    String s = SV.sValue((T)args[0]);
                    Object v = Escape.uP((String)(s.equalsIgnoreCase("best") ? this.vwr.getOrientationText(1073741864, null) : s));
                    if (!(v instanceof P4)) {
                        return false;
                    }
                    p4 = (P4)v;
                }
                if (tok != 0x8000003) break;
                q = Quat.newVA((T3)P3.new3((float)p4.x, (float)p4.y, (float)p4.z), (float)p4.w);
                break;
            }
            case 2: {
                Quat[] data1;
                if (tok == 134221850) {
                    Quat[] data2;
                    if (args[0].tok == 7 && args[1].tok == 7) {
                        data1 = this.e.getQuaternionArray((Object)args[0].getList(), 1073742001);
                        data2 = this.e.getQuaternionArray((Object)args[1].getList(), 1073742001);
                        qs = Quat.div((Quat[])data2, (Quat[])data1, (int)nMax, (boolean)isRelative);
                        break;
                    }
                    if (args[0].tok == 7 && args[1].tok == 1073742335) {
                        Quat[] data12 = this.e.getQuaternionArray((Object)args[0].getList(), 1073742001);
                        float[] stddev = new float[1];
                        Quat.sphereMean((Quat[])data12, (float[])stddev, (float)1.0E-4f);
                        return mp.addXFloat(stddev[0]);
                    }
                    if (args[0].tok == 10 && args[1].tok == 10) {
                        data1 = this.vwr.getAtomGroupQuaternions((BS)args[0].value, Integer.MAX_VALUE);
                        data2 = this.vwr.getAtomGroupQuaternions((BS)args[1].value, Integer.MAX_VALUE);
                        qs = Quat.div((Quat[])data2, (Quat[])data1, (int)nMax, (boolean)isRelative);
                        break;
                    }
                }
                P3 pt1 = mp.ptValue(args[1], null);
                p4 = mp.planeValue((T)args[0]);
                if (pt1 != null) {
                    q = Quat.getQuaternionFrame((P3)P3.new3((float)0.0f, (float)0.0f, (float)0.0f), (T3)pt0, (T3)pt1);
                    break;
                }
                q = Quat.newVA((T3)pt0, (float)SV.fValue((T)args[1]));
                break;
            }
            case 3: {
                if (args[0].tok == 9) {
                    P3 pt = args[2].tok == 8 ? (P3)args[2].value : this.vwr.ms.getAtomSetCenter((BS)args[2].value);
                    return mp.addXStr(Escape.drawQuat((Quat)Quat.newP4((P4)((P4)args[0].value)), (String)"q", (String)SV.sValue((T)args[1]), (P3)pt, (float)1.0f));
                }
                P3[] pts = new P3[3];
                for (int i = 0; i < 3; ++i) {
                    pts[i] = args[i].tok == 8 ? (P3)args[i].value : this.vwr.ms.getAtomSetCenter((BS)args[i].value);
                }
                q = Quat.getQuaternionFrame((P3)pts[0], (T3)pts[1], (T3)pts[2]);
                break;
            }
            case 4: {
                if (tok == 134221850) {
                    p4 = P4.new4((float)SV.fValue((T)args[1]), (float)SV.fValue((T)args[2]), (float)SV.fValue((T)args[3]), (float)SV.fValue((T)args[0]));
                    break;
                }
                q = Quat.newVA((T3)P3.new3((float)SV.fValue((T)args[0]), (float)SV.fValue((T)args[1]), (float)SV.fValue((T)args[2])), (float)SV.fValue((T)args[3]));
            }
        }
        if (qs != null) {
            if (nMax != Integer.MAX_VALUE) {
                Lst list = new Lst();
                for (int i = 0; i < qs.length; ++i) {
                    list.addLast((Object)qs[i].toPoint4f());
                }
                return mp.addXList(list);
            }
            q = qs.length > 0 ? qs[0] : null;
        }
        return mp.addXPt4((q == null ? Quat.newP4((P4)p4) : q).toPoint4f());
    }

    private boolean evaluateRandom(ScriptMathProcessor mp, SV[] args) {
        if (args.length > 3) {
            return false;
        }
        if (this.rand == null) {
            this.rand = new Random();
        }
        float lower = 0.0f;
        float upper = 1.0f;
        switch (args.length) {
            case 3: {
                this.rand.setSeed((int)SV.fValue((T)args[2]));
            }
            case 2: {
                upper = SV.fValue((T)args[1]);
            }
            case 1: {
                lower = SV.fValue((T)args[0]);
            }
            case 0: {
                break;
            }
            default: {
                return false;
            }
        }
        return mp.addXFloat(this.rand.nextFloat() * (upper - lower) + lower);
    }

    private boolean evaluateRowCol(ScriptMathProcessor mp, SV[] args, int tok) throws ScriptException {
        if (args.length != 1) {
            return false;
        }
        int n = args[0].asInt() - 1;
        SV x1 = mp.getX();
        switch (x1.tok) {
            case 11: {
                if (n < 0 || n > 2) {
                    return false;
                }
                M3 m = (M3)x1.value;
                switch (tok) {
                    case 1275068935: {
                        float[] f = new float[3];
                        m.getRow(n, f);
                        return mp.addXAF(f);
                    }
                }
                float[] f = new float[3];
                m.getColumn(n, f);
                return mp.addXAF(f);
            }
            case 12: {
                if (n < 0 || n > 2) {
                    return false;
                }
                M4 m4 = (M4)x1.value;
                switch (tok) {
                    case 1275068935: {
                        float[] f = new float[4];
                        m4.getRow(n, f);
                        return mp.addXAF(f);
                    }
                }
                float[] f = new float[4];
                m4.getColumn(n, f);
                return mp.addXAF(f);
            }
            case 7: {
                Lst l1 = x1.getList();
                Lst l2 = new Lst();
                int len = l1.size();
                for (int i = 0; i < len; ++i) {
                    Lst l3 = ((SV)l1.get(i)).getList();
                    if (l3 == null) {
                        return mp.addXStr("");
                    }
                    l2.addLast((Object)(n < l3.size() ? (SV)l3.get(n) : SV.newS((String)"")));
                }
                return mp.addXList(l2);
            }
        }
        return false;
    }

    private boolean evaluateIn(ScriptMathProcessor mp, SV[] args) throws ScriptException {
        SV x1 = mp.getX();
        switch (args.length) {
            case 1: {
                Lst lst = args[0].getList();
                if (lst == null) break;
                int n = lst.size();
                for (int i = 0; i < n; ++i) {
                    if (!SV.areEqual((SV)x1, (SV)((SV)lst.get(i)))) continue;
                    return mp.addXInt(i + 1);
                }
                break;
            }
            default: {
                for (int i = 0; i < args.length; ++i) {
                    if (!SV.areEqual((SV)x1, (SV)args[i])) continue;
                    return mp.addXInt(i + 1);
                }
            }
        }
        return mp.addXInt(0);
    }

    private boolean evaluateReplace(ScriptMathProcessor mp, SV[] args) throws ScriptException {
        String sFind;
        String sReplace;
        boolean isAll = false;
        switch (args.length) {
            case 0: {
                isAll = true;
                sReplace = null;
                sFind = null;
                break;
            }
            case 3: {
                isAll = SV.bValue((T)args[2]);
            }
            case 2: {
                sFind = SV.sValue((T)args[0]);
                sReplace = SV.sValue((T)args[1]);
                break;
            }
            default: {
                return false;
            }
        }
        SV x = mp.getX();
        if (x.tok == 7) {
            String[] list = SV.strListValue((T)x);
            String[] l = new String[list.length];
            int i = list.length;
            while (--i >= 0) {
                l[i] = sFind == null ? PT.clean((String)list[i]) : (isAll ? PT.replaceAllCharacters((String)list[i], (String)sFind, (String)sReplace) : PT.rep((String)list[i], (String)sFind, (String)sReplace));
            }
            return mp.addXAS(l);
        }
        String s = SV.sValue((T)x);
        return mp.addXStr(sFind == null ? PT.clean((String)s) : (isAll ? PT.replaceAllCharacters((String)s, (String)sFind, (String)sReplace) : PT.rep((String)s, (String)sFind, (String)sReplace)));
    }

    private boolean evaluateScript(ScriptMathProcessor mp, SV[] args, int tok) throws ScriptException {
        if ((tok == 134222350 || tok == 134238732) && args.length != 1 || args.length == 0) {
            return false;
        }
        String s = SV.sValue((T)args[0]);
        SB sb = new SB();
        switch (tok) {
            case 134218759: {
                return args.length == 2 ? s.equalsIgnoreCase("JSON") && mp.addXObj((Object)this.vwr.parseJSON(SV.sValue((T)args[1]))) : mp.addXObj((Object)this.vwr.evaluateExpressionAsVariable((Object)s));
            }
            case 134222850: {
                String appID;
                String string = appID = args.length == 2 ? SV.sValue((T)args[1]) : ".";
                if (!appID.equals(".")) {
                    sb.append(this.vwr.jsEval(appID + "\u0001" + s));
                }
                if (!appID.equals(".") && !appID.equals("*")) break;
                this.e.runScriptBuffer(s, sb, true);
                break;
            }
            case 134222350: {
                this.e.runScriptBuffer("show " + s, sb, true);
                break;
            }
            case 134238732: {
                return mp.addX(this.vwr.jsEvalSV(s));
            }
        }
        s = sb.toString();
        float f = PT.parseFloatStrict((String)s);
        return Float.isNaN(f) ? mp.addXStr(s) : (s.indexOf(".") >= 0 ? mp.addXFloat(f) : mp.addXInt(PT.parseInt((String)s)));
    }

    private boolean evaluateSort(ScriptMathProcessor mp, SV[] args, int tok) throws ScriptException {
        SV match;
        if (args.length > 1) {
            return false;
        }
        if (tok == 1275068444) {
            if (args.length == 1 && args[0].tok == 4) {
                return mp.addX(mp.getX().sortMapArray(args[0].asString()));
            }
            int n = args.length == 0 ? 0 : args[0].asInt();
            return mp.addX(mp.getX().sortOrReverse(n));
        }
        SV x = mp.getX();
        SV sV = match = args.length == 0 ? null : args[0];
        if (x.tok == 4) {
            int pt;
            int n = 0;
            String s = SV.sValue((T)x);
            if (match == null) {
                return mp.addXInt(0);
            }
            String m = SV.sValue((T)match);
            for (int i = 0; i < s.length() && (pt = s.indexOf(m, i)) >= 0; ++i) {
                ++n;
                i = pt;
            }
            return mp.addXInt(n);
        }
        Lst counts = new Lst();
        SV last = null;
        SV count = null;
        Lst xList = SV.getVariable((Object)x.value).sortOrReverse(0).getList();
        if (xList == null) {
            return match == null ? mp.addXStr("") : mp.addXInt(0);
        }
        int nLast = xList.size();
        for (int i = 0; i <= nLast; ++i) {
            SV a;
            SV sV2 = a = i == nLast ? null : (SV)xList.get(i);
            if (match != null && a != null && !SV.areEqual((SV)a, (SV)match)) continue;
            if (SV.areEqual((SV)a, last)) {
                ++count.intValue;
                continue;
            }
            if (last != null) {
                Lst y = new Lst();
                y.addLast((Object)last);
                y.addLast((Object)count);
                counts.addLast((Object)SV.getVariableList((Lst)y));
            }
            count = SV.newI((int)1);
            last = a;
        }
        if (match == null) {
            return mp.addX(SV.getVariableList((Lst)counts));
        }
        if (counts.isEmpty()) {
            return mp.addXInt(0);
        }
        return mp.addX((SV)((SV)counts.get(0)).getList().get(1));
    }

    private boolean evaluateString(ScriptMathProcessor mp, int tok, SV[] args) throws ScriptException {
        SV x = mp.getX();
        String sArg = args.length > 0 ? SV.sValue((T)args[0]) : (tok == 1275068932 ? "" : "\n");
        switch (args.length) {
            case 0: 
            case 1: {
                break;
            }
            case 2: {
                if (x.tok == 7) break;
                if (tok == 1275069447) {
                    x = SV.getVariable((Object)PT.split((String)PT.rep((String)((String)x.value), (String)"\n\r", (String)"\n").replace('\r', '\n'), (String)"\n"));
                    break;
                }
            }
            default: {
                return false;
            }
        }
        if (x.tok == 7 && tok != 1275068932 && (tok != 1275069447 || args.length == 2)) {
            mp.addX(x);
            return this.evaluateList(mp, tok, args);
        }
        String s = tok == 1275069447 && x.tok == 10 || tok == 1275068932 && x.tok == 7 ? null : SV.sValue((T)x);
        switch (tok) {
            case 1275069447: {
                if (x.tok == 10) {
                    BS bsSelected = (BS)x.value;
                    int modelCount = this.vwr.ms.mc;
                    Lst lst = new Lst();
                    for (int i = 0; i < modelCount; ++i) {
                        BS bs = this.vwr.getModelUndeletedAtomsBitSet(i);
                        bs.and(bsSelected);
                        lst.addLast((Object)SV.getVariable((Object)bs));
                    }
                    return mp.addXList(lst);
                }
                return mp.addXAS(PT.split((String)s, (String)sArg));
            }
            case 1275069446: {
                if (s.length() > 0 && s.charAt(s.length() - 1) == '\n') {
                    s = s.substring(0, s.length() - 1);
                }
                return mp.addXStr(PT.rep((String)s, (String)"\n", (String)sArg));
            }
            case 1275068932: {
                if (s != null) {
                    return mp.addXStr(PT.trim((String)s, (String)sArg));
                }
                String[] list = SV.strListValue((T)x);
                int i = list.length;
                while (--i >= 0) {
                    list[i] = PT.trim((String)list[i], (String)sArg);
                }
                return mp.addXAS(list);
            }
        }
        return mp.addXStr("");
    }

    private boolean evaluateSubstructure(ScriptMathProcessor mp, SV[] args, int tok, boolean isSelector) throws ScriptException {
        if (args.length == 0 || isSelector && args.length > 1) {
            return false;
        }
        BS bs = new BS();
        String pattern = SV.sValue((T)args[0]);
        if (pattern.length() > 0) {
            try {
                BS bsSelected = isSelector ? (BS)mp.getX().value : (args.length == 2 && args[1].tok == 10 ? (BS)args[1].value : null);
                bs = this.vwr.getSmilesMatcher().getSubstructureSet(pattern, (Node[])this.vwr.ms.at, this.vwr.ms.ac, bsSelected, tok == 134218757 ? 1 : 2);
            }
            catch (Exception ex) {
                this.e.evalError(ex.getMessage(), null);
            }
        }
        return mp.addXBs(bs);
    }

    private boolean evaluateSymop(ScriptMathProcessor mp, SV[] args, boolean haveBitSet) throws ScriptException {
        int nth;
        int narg;
        BS bsAtoms;
        SV x1;
        SV sV = x1 = haveBitSet ? mp.getX() : null;
        if (x1 != null && x1.tok != 10) {
            return false;
        }
        BS bS = bsAtoms = x1 == null ? null : (BS)x1.value;
        if (bsAtoms == null && this.vwr.ms.mc == 1) {
            bsAtoms = this.vwr.getModelUndeletedAtomsBitSet(0);
        }
        if ((narg = args.length) == 0) {
            if (bsAtoms.isEmpty()) {
                return false;
            }
            String[] ops = PT.split((String)PT.trim((String)((String)this.vwr.getSymTemp().getSpaceGroupInfo(this.vwr.ms, null, (int)this.vwr.ms.at[bsAtoms.nextSetBit((int)0)].mi).get("symmetryInfo")), (String)"\n"), (String)"\n");
            Lst lst = new Lst();
            int n = ops.length;
            for (int i = 0; i < n; ++i) {
                lst.addLast((Object)PT.split((String)ops[i], (String)"\t"));
            }
            return mp.addXList(lst);
        }
        String xyz = null;
        int iOp = Integer.MIN_VALUE;
        int apt = 0;
        switch (args[0].tok) {
            case 4: {
                xyz = SV.sValue((T)args[0]);
                ++apt;
                break;
            }
            case 12: {
                xyz = args[0].escape();
                ++apt;
                break;
            }
            case 2: {
                iOp = args[0].asInt();
                ++apt;
            }
        }
        if (bsAtoms == null) {
            if (apt < narg && args[apt].tok == 10) {
                bsAtoms = new BS();
                bsAtoms.or((BS)args[apt].value);
            }
            if (apt + 1 < narg && args[apt + 1].tok == 10) {
                (bsAtoms == null ? (bsAtoms = new BS()) : bsAtoms).or((BS)args[apt + 1].value);
            }
        }
        P3 pt1 = null;
        P3 pt2 = null;
        pt1 = narg > apt ? mp.ptValue(args[apt], bsAtoms) : null;
        if (pt1 != null) {
            ++apt;
        }
        if ((pt2 = narg > apt ? mp.ptValue(args[apt], bsAtoms) : null) != null) {
            ++apt;
        }
        int n = nth = pt2 != null && args.length > apt && iOp == Integer.MIN_VALUE && args[apt].tok == 2 ? args[apt].intValue : 0;
        if (nth > 0) {
            ++apt;
        }
        if (iOp == Integer.MIN_VALUE) {
            iOp = 0;
        }
        String desc = narg == apt ? (pt2 != null ? "all" : (pt1 != null ? "point" : "matrix")) : SV.sValue((T)args[apt++]).toLowerCase();
        return bsAtoms != null && !bsAtoms.isEmpty() && apt == args.length && mp.addXObj(this.vwr.getSymTemp().getSymmetryInfoAtom(this.vwr.ms, bsAtoms.nextSetBit(0), xyz, iOp, pt1, pt2, desc, 0, 0.0f, nth));
    }

    private boolean evaluateTensor(ScriptMathProcessor mp, SV[] args) throws ScriptException {
        SV x = mp.getX();
        if (args.length > 2 || x.tok != 10) {
            return false;
        }
        BS bs = (BS)x.value;
        String tensorType = args.length == 0 ? null : SV.sValue((T)args[0]).toLowerCase();
        JmolNMRInterface calc = this.vwr.getNMRCalculation();
        if ("unique".equals(tensorType)) {
            return mp.addXBs(calc.getUniqueTensorSet(bs));
        }
        String infoType = args.length < 2 ? null : SV.sValue((T)args[1]).toLowerCase();
        return mp.addXList(calc.getTensorInfo(tensorType, infoType, bs));
    }

    private boolean evaluateUserFunction(ScriptMathProcessor mp, String name, SV[] args, int tok, boolean isSelector) throws ScriptException {
        SV x1 = null;
        if (isSelector) {
            x1 = mp.getX();
            switch (x1.tok) {
                case 10: {
                    break;
                }
                case 6: {
                    if (args.length > 0) {
                        return false;
                    }
                    return (x1 = (SV)x1.getMap().get(name)) == null ? mp.addXStr("") : mp.addX(x1);
                }
                default: {
                    return false;
                }
            }
        }
        name = name.toLowerCase();
        mp.wasX = false;
        Lst params = new Lst();
        for (int i = 0; i < args.length; ++i) {
            params.addLast((Object)args[i]);
        }
        if (isSelector) {
            return mp.addXObj(this.e.getBitsetProperty((BS)x1.value, tok, null, null, x1.value, (Object)new Object[]{name, params}, false, x1.index, false));
        }
        SV var = this.e.getUserFunctionResult(name, params, null);
        return var == null ? false : mp.addX(var);
    }

    private boolean evaluateWithin(ScriptMathProcessor mp, SV[] args) throws ScriptException {
        BS bs;
        if (args.length < 1 || args.length > 5) {
            return false;
        }
        int len = args.length;
        if (len == 1 && args[0].tok == 10) {
            return mp.addX(args[0]);
        }
        float distance = 0.0f;
        Object withinSpec = args[0].value;
        String withinStr = "" + withinSpec;
        int tok = args[0].tok;
        if (tok == 4) {
            tok = T.getTokFromName((String)withinStr);
        }
        ModelSet ms = this.vwr.ms;
        boolean isVdw = false;
        boolean isWithinModelSet = false;
        boolean isWithinGroup = false;
        boolean isDistance = false;
        RadiusData rd = null;
        block0 : switch (tok) {
            case 1648363544: {
                isVdw = true;
                withinSpec = null;
            }
            case 2: 
            case 3: {
                isDistance = true;
                if (len < 2 || len == 3 && args[1].tok == 7 && args[2].tok != 7) {
                    return false;
                }
                distance = isVdw ? 100.0f : SV.fValue((T)args[0]);
                tok = args[1].tok;
                switch (tok) {
                    case 1073742334: 
                    case 1073742335: {
                        isWithinModelSet = args[1].asBoolean();
                        if (len > 2 && SV.sValue((T)args[2]).equalsIgnoreCase("unitcell")) {
                            tok = 1814695966;
                        }
                        len = 0;
                        break block0;
                    }
                    case 4: {
                        String s = SV.sValue((T)args[1]);
                        if (s.startsWith("$")) {
                            return mp.addXBs(this.getAtomsNearSurface(distance, s.substring(1)));
                        }
                        if (s.equalsIgnoreCase("group")) {
                            isWithinGroup = true;
                            tok = 1086324742;
                            break block0;
                        }
                        if (s.equalsIgnoreCase("vanderwaals") || s.equalsIgnoreCase("vdw")) {
                            withinSpec = null;
                            isVdw = true;
                            tok = 1648363544;
                            break block0;
                        }
                        if (s.equalsIgnoreCase("unitcell")) {
                            tok = 1814695966;
                            break block0;
                        }
                        return false;
                    }
                }
                break;
            }
            case 7: {
                if (len != 1) break;
                withinSpec = args[0].asString();
                tok = 0;
                break;
            }
            case 1073742328: {
                return len == 3 && args[1].value instanceof BS && args[2].value instanceof BS && mp.addXBs(this.vwr.getBranchBitSet(((BS)args[2].value).nextSetBit(0), ((BS)args[1].value).nextSetBit(0), true));
            }
            case 0x8000404: 
            case 134218757: 
            case 1237320707: {
                BS bsSelected = null;
                boolean isOK = true;
                switch (len) {
                    case 2: {
                        break;
                    }
                    case 3: {
                        boolean bl = isOK = args[2].tok == 10;
                        if (!isOK) break;
                        bsSelected = (BS)args[2].value;
                        break;
                    }
                    default: {
                        isOK = false;
                    }
                }
                if (!isOK) {
                    this.e.invArg();
                }
                return mp.addXObj(this.e.getSmilesExt().getSmilesMatches(SV.sValue((T)args[1]), null, bsSelected, null, tok == 0x8000404 ? 2 : 1, mp.asBitSet, false));
            }
        }
        if (withinSpec instanceof String) {
            if (tok == 0) {
                tok = 1073742362;
                if (len > 2) {
                    return false;
                }
                len = 2;
            }
        } else if (!isDistance) {
            return false;
        }
        block15 : switch (len) {
            case 1: {
                switch (tok) {
                    case 0x200020: 
                    case 136314895: 
                    case 1678381065: {
                        return mp.addXBs(ms.getAtoms(tok, null));
                    }
                    case 1073741863: {
                        return mp.addXBs(ms.getAtoms(tok, (Object)""));
                    }
                    case 1073742362: {
                        return mp.addXBs(ms.getAtoms(1086324744, (Object)withinStr));
                    }
                }
                return false;
            }
            case 2: {
                switch (tok) {
                    case 1073742362: {
                        tok = 1086324744;
                        break block15;
                    }
                    case 0x40000000: 
                    case 1073741863: 
                    case 1073741925: 
                    case 1073742128: 
                    case 1073742189: 
                    case 1086324744: 
                    case 1086326785: 
                    case 1086326786: 
                    case 1111490587: {
                        return mp.addXBs(this.vwr.ms.getAtoms(tok, (Object)SV.sValue((T)args[args.length - 1])));
                    }
                }
                break;
            }
            case 3: {
                switch (tok) {
                    case 7: 
                    case 8: 
                    case 134217750: 
                    case 134219265: 
                    case 1073742329: 
                    case 1073742334: 
                    case 1073742335: 
                    case 1086324742: 
                    case 1648363544: 
                    case 1814695966: {
                        break block15;
                    }
                    case 1086324744: {
                        withinStr = SV.sValue((T)args[2]);
                        break block15;
                    }
                }
                return false;
            }
        }
        P4 plane = null;
        P3 pt = null;
        Lst pts1 = null;
        int last = args.length - 1;
        switch (args[last].tok) {
            case 9: {
                plane = (P4)args[last].value;
                break;
            }
            case 8: {
                pt = (P3)args[last].value;
                if (!SV.sValue((T)args[1]).equalsIgnoreCase("hkl")) break;
                plane = this.e.getHklPlane(pt);
                break;
            }
            case 7: {
                Lst lst = pts1 = last == 2 && args[1].tok == 7 ? args[1].getList() : null;
                Object object = last == 2 ? SV.ptValue((SV)args[1]) : (pt = last == 1 ? P3.new3((float)Float.NaN, (float)0.0f, (float)0.0f) : null);
            }
        }
        if (plane != null) {
            return mp.addXBs(ms.getAtomsNearPlane(distance, plane));
        }
        BS bS = bs = args[last].tok == 10 ? (BS)args[last].value : null;
        if (last > 0 && pt == null && pts1 == null && bs == null) {
            return false;
        }
        if (tok == 1814695966) {
            boolean asMap = isWithinModelSet;
            return (bs != null || pt != null) && mp.addXObj(this.vwr.ms.getUnitCellPointsWithin(distance, bs, pt, asMap));
        }
        if (pt != null || pts1 != null) {
            if (args[last].tok == 7) {
                Lst sv = args[last].getList();
                Lst pts = new Lst();
                Bspt bspt = new Bspt(3, 0);
                if (pt != null && Float.isNaN(pt.x)) {
                    Point3fi p;
                    Point3fi[] pt3 = new Point3fi[sv.size()];
                    int i = pt3.length;
                    while (--i >= 0) {
                        P3 p3 = SV.ptValue((SV)((SV)sv.get(i)));
                        if (p3 == null) {
                            return false;
                        }
                        p = new Point3fi();
                        p.setT((T3)p3);
                        p.i = i;
                        pt3[i] = p;
                        bspt.addTuple((T3)p);
                    }
                    CubeIterator iter = bspt.allocateCubeIterator();
                    BS bsp = BSUtil.newBitSet2((int)0, (int)sv.size());
                    int i2 = pt3.length;
                    while (--i2 >= 0) {
                        p = pt3[i2];
                        iter.initialize((T3)p, distance, false);
                        float d2 = distance * distance;
                        int n = 0;
                        while (iter.hasMoreElements()) {
                            Point3fi pt2 = (Point3fi)iter.nextElement();
                            if (!bsp.get(pt2.i) || !(pt2.distanceSquared((T3)p) <= d2) || ++n <= 1) continue;
                            bsp.clear(pt2.i);
                        }
                    }
                    i2 = bsp.nextSetBit(0);
                    while (i2 >= 0) {
                        pts.addLast((Object)P3.newP((T3)pt3[i2]));
                        i2 = bsp.nextSetBit(i2 + 1);
                    }
                    return mp.addXList(pts);
                }
                if (distance == 0.0f) {
                    if (pts1 == null) {
                        float d2 = Float.MAX_VALUE;
                        P3 pt3 = null;
                        int i = sv.size();
                        while (--i >= 0) {
                            P3 pta = SV.ptValue((SV)((SV)sv.get(i)));
                            distance = pta.distanceSquared((T3)pt);
                            if (!(distance < d2)) continue;
                            pt3 = pta;
                            d2 = distance;
                        }
                        return pt3 == null ? mp.addXStr("") : mp.addXPt(pt3);
                    }
                    int[] ptsOut = new int[pts1.size()];
                    int i = ptsOut.length;
                    while (--i >= 0) {
                        float d2 = Float.MAX_VALUE;
                        int imin = -1;
                        pt = SV.ptValue((SV)((SV)pts1.get(i)));
                        int j = sv.size();
                        while (--j >= 0) {
                            P3 pta = SV.ptValue((SV)((SV)sv.get(j)));
                            distance = pta.distanceSquared((T3)pt);
                            if (!(distance < d2)) continue;
                            imin = j;
                            d2 = distance;
                        }
                        ptsOut[i] = imin;
                    }
                    return mp.addXAI(ptsOut);
                }
                int i = sv.size();
                while (--i >= 0) {
                    P3 ptp = SV.ptValue((SV)((SV)sv.get(i)));
                    bspt.addTuple((T3)ptp);
                }
                CubeIterator iter = bspt.allocateCubeIterator();
                iter.initialize((T3)pt, distance, false);
                float d2 = distance * distance;
                while (iter.hasMoreElements()) {
                    T3 pt2 = iter.nextElement();
                    if (!(pt2.distanceSquared((T3)pt) <= d2)) continue;
                    pts.addLast((Object)pt2);
                }
                iter.release();
                return mp.addXList(pts);
            }
            return mp.addXBs(this.vwr.getAtomsNearPt(distance, pt));
        }
        if (tok == 1086324744) {
            return mp.addXBs(this.vwr.ms.getSequenceBits(withinStr, bs, new BS()));
        }
        if (bs == null) {
            bs = new BS();
        }
        if (!isDistance) {
            return mp.addXBs(this.vwr.ms.getAtoms(tok, (Object)bs));
        }
        if (isWithinGroup) {
            return mp.addXBs(this.vwr.getGroupsWithin((int)distance, bs));
        }
        if (isVdw) {
            rd = new RadiusData(null, distance > 10.0f ? distance / 100.0f : distance, distance > 10.0f ? RadiusData.EnumType.FACTOR : RadiusData.EnumType.OFFSET, VDW.AUTO);
            if (distance < 0.0f) {
                distance = 0.0f;
            }
        }
        return mp.addXBs(this.vwr.ms.getAtomsWithinRadius(distance, bs, isWithinModelSet, rd));
    }

    private boolean evaluateWrite(ScriptMathProcessor mp, SV[] args) throws ScriptException {
        switch (args.length) {
            case 0: {
                return false;
            }
            case 1: {
                if (!args[0].asString().toUpperCase().equals("PNGJ")) break;
                return mp.addXMap(this.vwr.fm.getFileAsMap(null));
            }
        }
        return mp.addXStr(this.e.getCmdExt().dispatch(134221856, true, (T[])args));
    }

    private BS getAtomsNearSurface(float distance, String surfaceId) {
        Object[] data = new Object[]{surfaceId, null, null};
        if (this.e.getShapePropertyData(24, "getVertices", data)) {
            return this.getAtomsNearPts(distance, (T3[])data[1], (BS)data[2]);
        }
        data[1] = 0;
        data[2] = -1;
        if (this.e.getShapePropertyData(22, "getCenter", data)) {
            return this.vwr.getAtomsNearPt(distance, (P3)data[2]);
        }
        return new BS();
    }

    private BS getAtomsNearPts(float distance, T3[] points, BS bsInclude) {
        BS bsResult = new BS();
        if (points.length == 0 || bsInclude != null && bsInclude.isEmpty()) {
            return bsResult;
        }
        if (bsInclude == null) {
            bsInclude = BSUtil.setAll((int)points.length);
        }
        Atom[] at = this.vwr.ms.at;
        int i = this.vwr.ms.ac;
        block0: while (--i >= 0) {
            Atom atom = at[i];
            int j = bsInclude.nextSetBit(0);
            while (j >= 0) {
                if (atom.distance(points[j]) < distance) {
                    bsResult.set(i);
                    continue block0;
                }
                j = bsInclude.nextSetBit(j + 1);
            }
        }
        return bsResult;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getMinMax(Object floatOrSVArray, int tok) {
        double sum;
        int minMax;
        float[] data = null;
        Lst sv = null;
        int ndata = 0;
        Hashtable<String, Integer> htPivot = null;
        if (AU.isAF((Object)floatOrSVArray)) {
            if (tok == 1140850707) {
                return "NaN";
            }
            data = (float[])floatOrSVArray;
            ndata = data.length;
            if (ndata == 0) {
                return "NaN";
            }
        } else {
            if (!(floatOrSVArray instanceof Lst)) return "NaN";
            sv = (Lst)floatOrSVArray;
            ndata = sv.size();
            if (ndata == 0) {
                if (tok != 1140850707) {
                    return "NaN";
                }
            } else {
                SV sv0 = (SV)sv.get(0);
                if (sv0.tok == 8) {
                    return this.getMinMaxPoint(sv, tok);
                }
                if (sv0.tok == 4 && ((String)sv0.value).startsWith("{")) {
                    P3 pt = SV.ptValue((SV)sv0);
                    if (pt instanceof P3) {
                        return this.getMinMaxPoint(sv, tok);
                    }
                    if (!(pt instanceof P4)) return "NaN";
                    return this.getMinMaxQuaternion((Lst<SV>)sv, tok);
                }
            }
        }
        boolean isMin = false;
        switch (tok) {
            case 1140850707: {
                htPivot = new Hashtable<String, Integer>();
                minMax = 0;
                sum = 0;
                break;
            }
            case 32: {
                isMin = true;
                sum = 3.4028234663852886E38;
                minMax = Integer.MAX_VALUE;
                break;
            }
            case 64: {
                sum = -3.4028234663852886E38;
                minMax = -2147483647;
                break;
            }
            default: {
                minMax = 0;
                sum = 0;
            }
        }
        double sum2 = 0.0;
        int n = 0;
        boolean isInt = true;
        boolean isPivot = tok == 1140850707;
        int i = ndata;
        while (--i >= 0) {
            float v;
            SV svi;
            SV sV = svi = sv == null ? SV.vF : (SV)sv.get(i);
            float f = isPivot ? 1.0f : (v = data == null ? SV.fValue((T)svi) : data[i]);
            if (Float.isNaN(v)) continue;
            ++n;
            switch (tok) {
                case 160: 
                case 192: {
                    sum2 += (double)v * (double)v;
                }
                case 96: 
                case 128: {
                    sum += (double)v;
                    break;
                }
                case 1140850707: {
                    isInt &= svi.tok == 2;
                    String key = svi.asString();
                    Integer ii = (Integer)htPivot.get(key);
                    htPivot.put(key, ii == null ? new Integer(1) : new Integer(ii + 1));
                    break;
                }
                case 32: 
                case 64: {
                    isInt &= svi.tok == 2;
                    if (isMin != (double)v < sum) break;
                    sum = v;
                    if (!isInt) break;
                    minMax = svi.intValue;
                }
            }
        }
        if (tok == 1140850707) {
            return htPivot;
        }
        if (n == 0) return "NaN";
        switch (tok) {
            case 96: {
                sum /= (double)n;
                return Float.valueOf((float)sum);
            }
            case 192: {
                if (n == 1) return Float.valueOf((float)sum);
                sum = Math.sqrt((sum2 - sum * sum / (double)n) / (double)(n - 1));
                return Float.valueOf((float)sum);
            }
            case 32: 
            case 64: {
                if (!isInt) return Float.valueOf((float)sum);
                return minMax;
            }
            case 128: {
                return Float.valueOf((float)sum);
            }
            case 160: {
                sum = sum2;
            }
        }
        return Float.valueOf((float)sum);
    }

    private Object getMinMaxPoint(Object pointOrSVArray, int tok) {
        P3[] data = null;
        Lst sv = null;
        int ndata = 0;
        if (pointOrSVArray instanceof Quat[]) {
            data = (P3[])pointOrSVArray;
            ndata = data.length;
        } else if (pointOrSVArray instanceof Lst) {
            sv = (Lst)pointOrSVArray;
            ndata = sv.size();
        }
        if (sv == null && data == null) {
            return "NaN";
        }
        P3 result = new P3();
        float[] fdata = new float[ndata];
        block10: for (int xyz = 0; xyz < 3; ++xyz) {
            block11: for (int i = 0; i < ndata; ++i) {
                P3 pt;
                P3 p3 = pt = data == null ? SV.ptValue((SV)((SV)sv.get(i))) : data[i];
                if (pt == null) {
                    return "NaN";
                }
                switch (xyz) {
                    case 0: {
                        fdata[i] = pt.x;
                        continue block11;
                    }
                    case 1: {
                        fdata[i] = pt.y;
                        continue block11;
                    }
                    case 2: {
                        fdata[i] = pt.z;
                    }
                }
            }
            Object f = this.getMinMax(fdata, tok);
            if (!(f instanceof Number)) {
                return "NaN";
            }
            float value = ((Number)f).floatValue();
            switch (xyz) {
                case 0: {
                    result.x = value;
                    continue block10;
                }
                case 1: {
                    result.y = value;
                    continue block10;
                }
                case 2: {
                    result.z = value;
                }
            }
        }
        return result;
    }

    private Object getMinMaxQuaternion(Lst<SV> svData, int tok) {
        block7: {
            switch (tok) {
                case 32: 
                case 64: 
                case 128: 
                case 160: {
                    return "NaN";
                }
            }
            Quat[] data = this.e.getQuaternionArray(svData, 1073742001);
            if (data == null) break block7;
            float[] retStddev = new float[1];
            Quat result = Quat.sphereMean((Quat[])data, (float[])retStddev, (float)1.0E-4f);
            switch (tok) {
                case 96: {
                    return result;
                }
                case 192: {
                    return Float.valueOf(retStddev[0]);
                }
            }
        }
        return "NaN";
    }

    private JmolPatternMatcher getPatternMatcher() {
        return this.pm == null ? (this.pm = (JmolPatternMatcher)Interface.getUtil((String)"PatternMatcher", (Viewer)this.e.vwr, (String)"script")) : this.pm;
    }

    private T opTokenFor(int tok) {
        switch (tok) {
            case 1275069441: 
            case 1275069446: {
                return T.tokenPlus;
            }
            case 1275068931: {
                return T.tokenMinus;
            }
            case 1275068929: {
                return T.tokenTimes;
            }
            case 1275068930: {
                return T.tokenMul3;
            }
            case 1275068928: {
                return T.tokenDivide;
            }
        }
        return null;
    }

    public BS setContactBitSets(BS bsA, BS bsB, boolean localOnly, float distance, RadiusData rd, boolean warnMultiModel) {
        BS bs;
        boolean withinAllModels;
        if (bsB == null) {
            bsB = BSUtil.setAll((int)this.vwr.ms.ac);
            BSUtil.andNot((BS)bsB, (BS)this.vwr.slm.bsDeleted);
            bsB.andNot(bsA);
            withinAllModels = false;
        } else {
            bs = BSUtil.copy((BS)bsA);
            bs.or(bsB);
            int nModels = this.vwr.ms.getModelBS(bs, false).cardinality();
            boolean bl = withinAllModels = nModels > 1;
            if (warnMultiModel && nModels > 1 && !this.e.tQuiet) {
                this.e.showString(GT._((String)"Note: More than one model is involved in this contact!"));
            }
        }
        if (!bsA.equals((Object)bsB)) {
            boolean setBfirst;
            boolean bl = setBfirst = !localOnly || bsA.cardinality() < bsB.cardinality();
            if (setBfirst) {
                bs = this.vwr.ms.getAtomsWithinRadius(distance, bsA, withinAllModels, (RadiusData)(Float.isNaN(distance) ? rd : null));
                bsB.and(bs);
            }
            if (localOnly) {
                bs = this.vwr.ms.getAtomsWithinRadius(distance, bsB, withinAllModels, (RadiusData)(Float.isNaN(distance) ? rd : null));
                bsA.and(bs);
                if (!setBfirst) {
                    bs = this.vwr.ms.getAtomsWithinRadius(distance, bsA, withinAllModels, (RadiusData)(Float.isNaN(distance) ? rd : null));
                    bsB.and(bs);
                }
                bs = BSUtil.copy((BS)bsB);
                bs.and(bsA);
                if (bs.equals((Object)bsA)) {
                    bsB.andNot(bsA);
                } else if (bs.equals((Object)bsB)) {
                    bsA.andNot(bsB);
                }
            }
        }
        return bsB;
    }
}

