#!/usr/bin/python
#-*- coding: iso-8859-15 -*-
from __future__ import division
from gi.repository import Gtk, GObject
import os, sys
import serial
import string
from time import sleep
import glob

class AL991S:
	def __init__(self):

		self.builder = Gtk.Builder()
		self.builder.add_from_file("AL991S.glade")

		#recuperation des widgets utilises par le programme :
		self.lbA = self.builder.get_object("lbA")
		self.sbA = self.builder.get_object("sbA")
		self.btA = self.builder.get_object("btA")
		self.lbB = self.builder.get_object("lbB")
		self.sbB = self.builder.get_object("sbB")
		self.btB = self.builder.get_object("btB")
		self.lbC = self.builder.get_object("lbC")
		self.sbC = self.builder.get_object("sbC")
		self.btC = self.builder.get_object("btC")
		self.btOuvrir = self.builder.get_object("btOuvrir")
		self.btFermer = self.builder.get_object("btFermer")
		self.btQuitter = self.builder.get_object("btQuitter")
		self.btRafraichir = self.builder.get_object("btRafraichir")
		self.comboPort = self.builder.get_object("comboPort")
		self.textAide = self.builder.get_object("textAide")
		self.textAPropos = self.builder.get_object("textAPropos")

		self.buffer_aide = self.textAide.get_buffer()
		fichier_aide = open("Aide.txt", "r")
		if fichier_aide:
			texte_aide = fichier_aide.read()
			fichier_aide.close()
			self.buffer_aide.set_text(texte_aide)

		self.buffer_apropos = self.textAPropos.get_buffer()
		fichier_apropos = open("A_propos.txt", "r")
		if fichier_apropos:
			texte_apropos = fichier_apropos.read()
			fichier_apropos.close()
			self.buffer_apropos.set_text(texte_apropos)


		self.lb_etat = self.builder.get_object("lb_etat")
		self.lb_etat.set_text("Connexion non établie")
		self.builder.connect_signals(self)




		window = self.builder.get_object('window')
		window.show_all()

		self.lister_ports()

		#initialisations :
		self.sortie =""
		self.port_serie = " "
		self.port_choisi = " "
		self.data_format = " "
		self.debit = 9600
		self.parite = ""

		adjA = Gtk.Adjustment(0, 0, 15, 0.1, 0.1, 0)
		self.sbA.configure(adjA, 1,1)
		adjB = Gtk.Adjustment(2, 2, 5.5, 0.1, 0.1,0 )
		self.sbB.configure(adjB, 1,1)
		adjC = Gtk.Adjustment(0, -15, 15, 0.1, 0.1,0)
		self.sbC.configure(adjC, 1,1)

		self.btA.set_sensitive(False)
		self.btB.set_sensitive(False)
		self.btC.set_sensitive(False)
		self.btFermer.set_sensitive(False)
		self.btQuitter.set_sensitive(False)

	def lister_ports(self) :
		  list_port =  glob.glob('/dev/ttyUSB*') + glob.glob('/dev/ttyS*')
		  i = 0
		  while i < len(list_port):
			self.comboPort.append_text(list_port[i])
			i=i+1

	def lecture(self) :
		sleep(0.2)
		chaine = ""
		data = []
		n_data = self.port_serie.inWaiting()
		if n_data > 0 :
			for i in range (n_data) :
				data.append(ord(self.port_serie.read(1)))
				chaine += chr(data[i])
			index = chaine.find('\r\n>')
			if index == -1 :
				self.lecture_voies()
			else :
				self.sortie = chaine[index - 3] + str(int(chaine[index -2 : index],16)/10)
		return self.sortie

	def lecture_voies(self) :
		try :
			#lecture de chacune des 3 voies et affichage :
			self.port_serie.write('A?' + '\r' )
			self.lecture()
			self.lbA.set_text(self.sortie)

			self.port_serie.write('B?' + '\r' )
			self.lecture()
			self.lbB.set_text(self.sortie)

			self.port_serie.write('C?' + '\r' )
			self.lecture()
			self.lbC.set_text(self.sortie)
			return True
		except :
			self.lbA.set_text('xx.x')
			self.lbB.set_text('xx.x')
			self.lbC.set_text('xx.x')
			return False
		sleep(0.2)
		self.lecture_voies()

	def on_btA_clicked(self,widget):

		chaine = str(hex(int(str(self.sbA.get_value()).replace('.',''))).replace('0x','')).zfill(2)
		self.port_serie.write('A+' + chaine + '\r' )
		self.lecture_voies()

	def on_btB_clicked(self,widget):

		chaine = str(hex(int(str(self.sbB.get_value()).replace('.',''))).replace('0x','')).zfill(2)
		self.port_serie.write('B+' + chaine + '\r' )
		self.lecture_voies()

	def on_btC_clicked(self,widget):
		reglage = int(10*self.sbC.get_value())

		if reglage < 0 :
			chaine = str(hex(int(str(self.sbC.get_value()).replace('.',''))).replace('0x','')).zfill(3)
			self.port_serie.write('C' + chaine + '\r' )
		else :
			chaine = str(hex(int(str(self.sbC.get_value()).replace('.',''))).replace('0x','')).zfill(2)
			self.port_serie.write('C+' + chaine + '\r' )
		self.lecture_voies()

	def on_btRafraichir_clicked(self,widget):
		#Rafraichir la liste des ports série disponibles
		self.comboPort.remove_all()
		self.lister_ports()

	def on_btOuvrir_clicked(self,widget):
		#ouverture du port série choisi:
		# recuperation des parametres choisis :
		self.port_choisi = self.comboPort.get_active_text()
		debit = 9600
		data_format = serial.EIGHTBITS
		stop = serial.STOPBITS_ONE
		parite = serial.PARITY_NONE

		try:
			# desactivation de widgets (ceux qui ne doivent pas
			# etre modifies une fois le port serie ouvert) :
			self.comboPort.set_sensitive(False)
			self.btRafraichir.set_sensitive(False)
			self.btQuitter.set_sensitive(True)

			#ouverture du port serie :
			self.port_serie = serial.Serial(
				port=self.port_choisi,
				baudrate = debit,
				bytesize = data_format,
				parity = parite,
				stopbits = stop,
				timeout=2
			)

			#activation/desactivation de widgets :
			self.btFermer.set_sensitive(True)
			self.btOuvrir.set_sensitive(False)
			self.btA.set_sensitive(True)
			self.btB.set_sensitive(True)
			self.btC.set_sensitive(True)

			#vidage du port et tentative de contact avec l'alim :
			self.port_serie.flushInput()
			self.port_serie.write('R?' + '\r' )
			#petit délai avant de lire le retour :
			sleep(0.2)
			data = []
			char_ascii = []
			n_data = 0
			n_data = self.port_serie.inWaiting()
			if n_data > 0 :
				chaine = ""
				for i in range (n_data) :
					data.append(ord(self.port_serie.read(1)))

					chaine += chr(data[i])
				index = chaine.find('AL991', 0,len(chaine))
				self.lb_etat.set_text("Etat : connecté sur " + chaine[index : index + 10])
				GObject.timeout_add(1000, self.lecture_voies)
			else:
				self.lb_etat.set_text("L'alimentation est-elle allumée ?")

		except :
			self.comboPort.set_sensitive(True)
			self.btOuvrir.set_sensitive(True)
			self.btRafraichir.set_sensitive(True)

			#self.bt_fermer.set_sensitive(False)
			self.ouvert = False
			msg = "Erreur lors de l'ouverture du port série : ce port n'est peut-être pas valide, ou bien vous n'avez pas les droits pour accéder aux ports série"
			dialog = Gtk.MessageDialog(None, 0, Gtk.MessageType.WARNING, Gtk.ButtonsType.OK, msg)
			# Montre le dialog
			dialog.run()
			# Destruction du dialog
			dialog.destroy()

	def on_btFermer_clicked(self,widget):
		#fermeture du port série ouvert
		try :
			if self.port_serie.isOpen() == True:
				self.port_serie.close()
				self.comboPort.set_sensitive(True)
				self.btOuvrir.set_sensitive(True)
				self.btRafraichir.set_sensitive(True)
				self.btFermer.set_sensitive(False)
				self.btA.set_sensitive(False)
				self.btB.set_sensitive(False)
				self.btC.set_sensitive(False)
				self.lb_etat.set_text("Etat : déconnecté")
				self.lbA.set_text('xx.x')
				self.lbB.set_text('xx.x')
				self.lbC.set_text('xx.x')

		except :
			msgFermer = "Erreur lors de la fermeture du port série !"
			dlgFermer = Gtk.MessageDialog(None, 0, Gtk.MessageType.WARNING, Gtk.ButtonsType.OK, msgFermer)
			dlgFermer.run()
			dlgFermer.destroy()

	def on_btQuitter_clicked(self,widget):
		Gtk.main_quit()

	def destroy(window, self):
		Gtk.main_quit()

def main():
	app = AL991S()
	Gtk.main()

if __name__ == "__main__":
	sys.exit(main())
