#!/usr/bin/python
#-*- coding: iso-8859-15 -*-
from gi.repository import Gtk, GObject
import os, sys
from bitstring import BitArray  #ce module rend ais le retournement de l'octet
import usb.core
import usb.util

class REF_TENSION:
	def __init__(self):

		self.builder = Gtk.Builder()
		self.builder.add_from_file("reference_tension.glade")

		#recuperation des widgets utilises par le programme :
			
		self.lbA = self.builder.get_object("lbA")
		self.lbB = self.builder.get_object("lbB")
		self.scaleA = self.builder.get_object("scaleA")
		self.scaleB = self.builder.get_object("scaleB")
				
		self.builder.connect_signals(self)

		window = self.builder.get_object('window')
		window.show_all()
		
		#initialisations :
	
		ref_tension = usb.core.find(idVendor=0x0C70, idProduct = 0xF0A6)
		
		if ref_tension is None:	
			msg = "Carte Référence de tension non détectée : vérifier qu'elle est bien branchée sur un port USB, et bien alimentée ! Ce programme va se refermer ..."
			dialog = Gtk.MessageDialog(None, 0, Gtk.MessageType.WARNING, Gtk.ButtonsType.OK, msg) 
			# Montre le dialog
			dialog.run()
			# Destruction du dialog
			dialog.destroy()	

		config = ref_tension.get_active_configuration()
		interface = config[(0,0)]

		self.ep_out = usb.util.find_descriptor(interface, custom_match = lambda e: usb.util.endpoint_direction(e.bEndpointAddress)==usb.util.ENDPOINT_OUT)
				
		# mise  0 des deux voies
		self.ep_out.write(chr(0) + chr(0))
			
	def on_scaleA_value_changed(self,widget):			
		self.lbA.set_text(str("{:.2f}".format(self.scaleA.get_value()*3.3/256)))
		codeA = BitArray(uint=int(self.scaleA.get_value()), length=8)
		codeA.reverse()
		codeB = BitArray(uint=int(self.scaleB.get_value()), length=8)
		codeB.reverse()
		data = codeA.bytes + codeB.bytes
		self.ep_out.write(data)
		
	def on_scaleB_value_changed(self,widget):		
		self.lbB.set_text(str("{:.2f}".format(self.scaleB.get_value()*3.3/256)))
		codeA = BitArray(uint=int(self.scaleA.get_value()), length=8)
		codeA.reverse()		# retournement de l'octet
		codeB = BitArray(uint=int(self.scaleB.get_value()), length=8)
		codeB.reverse()		# retournement de l'octet
		data = codeA.bytes + codeB.bytes
		self.ep_out.write(data)
		
	def on_bt_Quitter_clicked(self,widget):
		self.ep_out.write(chr(0) + chr(0))	#remise  0 des deux voies
		Gtk.main_quit()
	
	def on_window_destroy(self,widget):
		self.ep_out.write(chr(0) + chr(0))   #remise  0 des deux voies
		Gtk.main_quit()
		
	def destroy(window, self):
		Gtk.main_quit()

def main():
	app = REF_TENSION()
	Gtk.main()

if __name__ == "__main__":
	
	sys.exit(main())
