#!/usr/bin/python
#-*- coding: iso-8859-15 -*-

# Copyright 2014 Vincent LE MIEUX

# Contact : vlemieux@laboiteaphysique.fr

# La version la plus rcente de ce programme se trouve
# sur le site de l'auteur : www.laboiteaphysique.fr

# Ce programme est un logiciel libre ; vous pouvez le redistribuer ou le modifier suivant 
# les termes de la GNU General Public License telle que publie par la Free Software Foundation ;
# soit la version 3 de la licence, soit ( votre gr) toute version ultrieure.

# Ce programme est distribu dans l'espoir qu'il sera utile, mais SANS AUCUNE GARANTIE ;
# sans mme la garantie tacite de QUALIT MARCHANDE ou d'ADQUATION  UN BUT PARTICULIER. 
# Consultez la GNU General Public License pour plus de dtails.

# Vous devez avoir reu une copie de la GNU General Public License en mme temps que ce programme ; 
# si ce n'est pas le cas, consultez <http://www.gnu.org/licenses>.

from gi.repository import Gtk, GObject

import os, sys
from time import sleep
import usb.core
import usb.util

import xlwt
from xlwt import Workbook

 
class THERMOMETRE(Gtk.Window):
	def __init__(self):

		self.builder = Gtk.Builder()
		self.builder.add_from_file("thermometre2.glade")

		#recuperation des widgets utilises par le programme :
			
		self.lbA = self.builder.get_object("lbA")
		self.swAcq = self.builder.get_object("swAcq")
		self.bt_Quitter = self.builder.get_object("bt_Quitter")
		self.bt_Save = self.builder.get_object("bt_Save")
		self.bt_Effacer = self.builder.get_object("bt_Effacer")
		self.sb_timer = self.builder.get_object("sb_timer")	
		self.textview = self.builder.get_object("textview")	
		self.textbuffer = self.builder.get_object("textbuffer")
		self.scrolledwindow1 = self.builder.get_object("scrolledwindow1")
		
		self.filechooserdialog = self.builder.get_object("filechooserdialog")
		self.cb_Filtre = self.builder.get_object("cb_Filtre")
		
		self.builder.connect_signals(self)

		window = self.builder.get_object('window')
		window.show_all()
		
		#initialisations :
		
		self.delai = 1000
		self.i = 0
		self.texte = ""
		self.cb_Filtre.set_active(0)
		
		self.texte = 't(s)' + '\t' + 'T(' + u"C" +')' + '\r' + '\n' 
		self.textbuffer.set_text("")
		
		
		
		#cration d'un classeur pour le tableur :
		global classeur
		classeur = Workbook()
		self.feuille1 = classeur.add_sheet("Mesures", cell_overwrite_ok=True)
		self.feuille1.write(0,0,'t(s)',xlwt.easyxf("align: horiz center"))
		self.feuille1.write(0,1,'T(' + u"C" +')',xlwt.easyxf("align: horiz center"))
		
		thermo = usb.core.find(idVendor=0x0C70, idProduct = 0xF0A3)
		
		if thermo is None:	
			msg = "Carte thermometre non détectée : vérifier qu'elle est bien branchée sur un port USB, et bien alimentée ! Ce programme va se refermer ..."
			dialog = Gtk.MessageDialog(None, 0, Gtk.MessageType.WARNING, Gtk.ButtonsType.OK, msg) 
			# Montre le dialog
			dialog.run()
			# Destruction du dialog
			dialog.destroy()		

		config = thermo.get_active_configuration()
		interface = config[(0,0)]

		self.ep_out = usb.util.find_descriptor(interface, custom_match = lambda e: usb.util.endpoint_direction(e.bEndpointAddress)==usb.util.ENDPOINT_OUT)		
		self.ep_in = usb.util.find_descriptor(interface, custom_match = lambda e: usb.util.endpoint_direction(e.bEndpointAddress)==usb.util.ENDPOINT_IN)
		
		self.pour_rien()
		self.affiche()
		self.timer_afficheur = GObject.timeout_add(300, self.affiche)
		
	def pour_rien(self):
		self.ep_out.write('M')
		sleep(0.02)
		pour_rien = self.ep_in.read(1)
		sleep(0.02)
		self.ep_out.write('M')
		sleep(0.02)
		pour_rien = self.ep_in.read(1)	
		
		
	def affiche(self):
		self.ep_out.write('M')
		temp_affiche = self.ep_in.read(1)	
		self.lbA.set_text(str("{:.1f}".format ( temp_affiche[0]*0.5)) + u" C")
		return True
		
	def mesure(self):
		if self.i < 65536 :
			self.ep_out.write('M')
			temperature = self.ep_in.read(1)	
			self.texte +=(str(self.i*self.delai/1000) + '\t' + str("{:.1f}".format (temperature[0]*0.5)).replace('.', ',') + '\r' + '\n' )
			self.textbuffer.set_text(self.texte)	
			adjustment = self.scrolledwindow1.get_vadjustment()
			adjustment.set_value(adjustment.get_upper())
			
			self.feuille1.write(self.i+1,0,self.i*self.delai/1000,xlwt.easyxf("align: horiz center"))
			self.feuille1.write(self.i+1,1,float(str("{:.1f}".format (temperature[0]*0.5))),xlwt.easyxf("align: horiz center"))
			self.i = self.i + 1
			return True		
	
	def on_sb_timer_value_changed(self,widget):
		self.delai = int(1000*self.sb_timer.get_value())
	
	def on_swAcq_button_press_event(self,widget,event):
		if widget.get_active()==False :
			self.pour_rien()
			self.effacer()
			self.mesure()
			self.timer_id = GObject.timeout_add(self.delai, self.mesure)
			
			self.bt_Quitter.set_sensitive(False)
			self.bt_Effacer.set_sensitive(False)
			self.bt_Save.set_sensitive(False)
			self.sb_timer.set_sensitive(False)
			
		else:
			GObject.source_remove(self.timer_id)
			self.bt_Quitter.set_sensitive(True)
			self.bt_Effacer.set_sensitive(True)
			self.bt_Save.set_sensitive(True)
			self.sb_timer.set_sensitive(True)
			
	def effacer(self):
		self.texte = ' '
		self.texte = 't(s)' + '\t' + 'T(' + u"C" +')' + '\r' + '\n' 
		self.textbuffer.set_text(self.texte)
		for j in range (self.i) :
			self.feuille1.write(j+1,0,'')
			self.feuille1.write(j+1,1,'')
		self.i = 0
			
	def on_bt_Effacer_clicked(self,widget) :
		self.effacer()
		
	def on_bt_Save_clicked(self,widget):
		reponse = self.filechooserdialog.run()
		if reponse == 1:		
			nom = self.filechooserdialog.get_filename()
			# Enregistrement format Calc :
			if self.cb_Filtre.get_active() ==0 :			
				if not nom.endswith('.ods'):
					fichier_ods = nom + '.ods'	
				else :
					fichier_ods = nom			
				with open(fichier_ods, 'w') :
					classeur.save(fichier_ods)
						
			# Enregistrement au format Gnumeric :			
			if self.cb_Filtre.get_active() == 1 :		
				if not nom.endswith('.gnumeric'):
					fichier_gnum = nom + '.gnumeric'
				else :
					fichier_gnum = nom				
				with open(fichier_gnum, 'w') :
					classeur.save(fichier_gnum)
		self.filechooserdialog.hide()
			
	def on_bt_Quitter_clicked(self,widget):
		Gtk.main_quit()
	
	def on_window_destroy(self,widget):
		GObject.source_remove(self.timer_id)
		GObject.source_remove(self.timer_afficheur)
		Gtk.main_quit()
		
	def destroy(window, self):
		GObject.source_remove(self.timer_id)
		GObject.source_remove(self.timer_afficheur)
		Gtk.main_quit()

def main():
	app = THERMOMETRE()
	Gtk.main()


	
if __name__ == "__main__":
	
	sys.exit(main())
