#!/usr/bin/python
#-*- coding: iso-8859-15 -*-
from gi.repository import Gtk, GObject
import os, sys

import usb.core
import usb.util


class RELAIS:
	def __init__(self):

		self.builder = Gtk.Builder()
		self.builder.add_from_file("carte_relais.glade")

		#recuperation des widgets utilises par le programme :
		
		self.switch0 = self.builder.get_object("switch0")
		self.switch1 = self.builder.get_object("switch1")
		self.switch2 = self.builder.get_object("switch2")
		self.switch3 = self.builder.get_object("switch3")
		self.switch4 = self.builder.get_object("switch4")
		self.switch5 = self.builder.get_object("switch5")
		self.switch6 = self.builder.get_object("switch6")
		self.switch7 = self.builder.get_object("switch7")
		
		self.bt_raz = self.builder.get_object("bt_raz")
				
		self.builder.connect_signals(self)

		window = self.builder.get_object('window')
		window.show_all()
		
		#initialisations :
		carte_relais = usb.core.find(idVendor=0x0C70, idProduct = 0xF0A4)
		
		if carte_relais is None:	
			msg = "Carte_relais non détectée : vérifier qu'elle est bien branchée sur un port USB, et bien alimentée ! Ce programme va se refermer ..."
			dialog = Gtk.MessageDialog(None, 0, Gtk.MessageType.WARNING, Gtk.ButtonsType.OK, msg) 
			# Montre le dialog
			dialog.run()
			# Destruction du dialog
			dialog.destroy()
		

		config = carte_relais.get_active_configuration()
		interface = config[(0,0)]

		self.ep_out = usb.util.find_descriptor(interface, custom_match = lambda e: usb.util.endpoint_direction(e.bEndpointAddress)==usb.util.ENDPOINT_OUT)
		
		self.r0 = 0
		self.r1 = 0
		self.r2 = 0
		self.r3 = 0
		self.r4 = 0
		self.r5 = 0
		self.r6 = 0
		self.r7 = 0
		self.r = 0
			
		self.raz()
	
	def on_switch0_button_press_event(self,widget,event):
		if self.switch0.get_active():
			self.r0 = 0
		else:
			self.r0 = 1
		self.envoyer_ordre()
		
	def on_switch1_button_press_event(self,widget,event):
		if self.switch1.get_active():
			self.r1 = 0
		else:
			self.r1 = 2
		self.envoyer_ordre()
	
	def on_switch2_button_press_event(self,widget,event):
		if self.switch2.get_active():
			self.r2 = 0
		else:
			self.r2 = 4
		self.envoyer_ordre()
		
	def on_switch3_button_press_event(self,widget,event):
		if self.switch3.get_active():
			self.r3 = 0
		else:
			self.r3 = 8
		self.envoyer_ordre()
		
	def on_switch4_button_press_event(self,widget,event):
		if self.switch4.get_active():
			self.r4 = 0
		else:
			self.r4 = 16
		self.envoyer_ordre()
	
	def on_switch5_button_press_event(self,widget,event):
		 
		if self.switch5.get_active():
			self.r5 = 0
		else:
			self.r5 = 32
		self.envoyer_ordre()
		
	def on_switch6_button_press_event(self,widget,event):
		if self.switch6.get_active():
			self.r6 = 0
		else:
			self.r6 = 64
		self.envoyer_ordre()
		
	def on_switch7_button_press_event(self,widget,event): 
		if self.switch7.get_active():
			self.r7 = 0
		else:
			self.r7 = 128
		self.envoyer_ordre()
		
	def envoyer_ordre(self):
		r = self.r0 + self.r1 + self.r2 + self.r3 + self.r4 + self.r5 + self.r6 + self.r7
		self.ep_out.write(chr(r))	
				
	def bt_raz_clicked(self,widget):
		self.raz()
	
	def raz(self):
		#Reouverture de tous les relais
		self.switch0.set_active(False)
		self.switch1.set_active(False)
		self.switch2.set_active(False)
		self.switch3.set_active(False)
		self.switch4.set_active(False)
		self.switch5.set_active(False)
		self.switch6.set_active(False)
		self.switch7.set_active(False)
		self.r0 = 0
		self.r1 = 0
		self.r2 = 0
		self.r3 = 0
		self.r4 = 0
		self.r5 = 0
		self.r6 = 0
		self.r7 = 0
		self.ep_out.write(chr(0))		
	
	def on_bt_Quitter_clicked(self,widget):
		self.raz()
		Gtk.main_quit()
	
	def on_window_destroy(self,widget):
		self.raz()
		Gtk.main_quit()
		
	def destroy(window, self):
		Gtk.main_quit()

def main():
	app = RELAIS()
	Gtk.main()

if __name__ == "__main__":
	
	sys.exit(main())
