#!/usr/bin/python
#-*- coding: iso-8859-15 -*-
from __future__ import division
from gi.repository import Gtk, GObject
import os, sys
import serial
import string
from time import sleep
import glob

class JAUGES:
	def __init__(self):

		self.builder = Gtk.Builder()
		self.builder.add_from_file("4jauges.glade")

		#recuperation des widgets utilises par le programme :
		self.lb0 = self.builder.get_object("lb0")
		self.lb1 = self.builder.get_object("lb1")
		self.lb2 = self.builder.get_object("lb2")
		self.lb3 = self.builder.get_object("lb3")

		self.pb0 = self.builder.get_object("pb0")
		self.pb1 = self.builder.get_object("pb1")
		self.pb2 = self.builder.get_object("pb2")
		self.pb3 = self.builder.get_object("pb3")

		self.sw0 = self.builder.get_object("sw0")
		self.sw1 = self.builder.get_object("sw1")
		self.sw2 = self.builder.get_object("sw2")
		self.sw3 = self.builder.get_object("sw3")

		self.cbAuto = self.builder.get_object("cbAuto")
		
		
		self.btOuvrir = self.builder.get_object("btOuvrir")
		self.btFermer = self.builder.get_object("btFermer")
		self.btQuitter = self.builder.get_object("btQuitter")
		self.btRafraichir = self.builder.get_object("btRafraichir")
		self.comboPort = self.builder.get_object("comboPort")
		self.textAide = self.builder.get_object("textAide")
		self.textAPropos = self.builder.get_object("textAPropos")
		self.buffer_aide = self.textAide.get_buffer()
		texte_aide = 'Ce logiciel permet de piloter sous Linux la carte ' + '\r' + '\n\n' \
		+ '4 jauges analogiques sur PC' + '\r' + '\n\n' \
		+ 'décrite dans l\'ouvrage' + '\r' + '\n\n' \
		+ 'L\'USB POUR TOUS (Editions DUNOD / ETSF)' + '\r' + '\n\n' \
		+ 'Sélectionner le port. Le bouton Ouvrir démarre les mesures' + '\r' + '\n\n' \
		+ 'Activer la ou les voies de mesures avec les boutons switch correspondants''\r' + '\n\n' \
		+' Tensions d\'entrée comprises entre 0 et 3,3 V'
		self.buffer_aide.set_text(texte_aide)

		self.buffer_apropos = self.textAPropos.get_buffer()
		texte_apropos = ' '+ '\r' + '\n'\
		+'4JAUGES - V1.0 ' + '\r' + '\n\n'\
		+ 'Date de publication : 20 Avril 2013' + '\r' + '\n\n'\
		+ 'par Vincent Le Mieux'+ '\r' + '\n' \
		+ ' Contact : vlemieux@laboiteaphysique.fr'+ '\r' + '\n\n' \
		+ 'Ce logiciel est écrit en Python (PyGTK + Glade).' + '\r' + '\n' \
		+ 'Dans sa version 1.0 il fonctionne sous GNU/Linux' + '\r' + '\n\n' \
		+ 'Testé sur :' + '\r' + '\n'\
		+ '  -Debian Wheezy'

		self.buffer_apropos.set_text(texte_apropos)

		self.builder.connect_signals(self)

		window = self.builder.get_object('window')
		window.show_all()

		self.lister_ports()

		#initialisations :
		self.sortie =""
		self.port_serie = " "
		self.port_choisi = " "
		self.data_format = " "
		self.debit = 9600
		self.parite = ""

		self.E0active = False
		self.E1active = False
		self.E2active = False
		self.E3active = False

		
		self.btFermer.set_sensitive(False)
		self.btQuitter.set_sensitive(False)

	def lister_ports(self) :
		  list_port =  glob.glob('/dev/ttyUSB*')
		  i = 0
		  while i < len(list_port):
			self.comboPort.append_text(list_port[i])
			i=i+1

	def on_sw0_button_press_event(self,widget,event):
		self.E0active = not self.E0active

	def on_sw1_button_press_event(self,widget,event):
		self.E1active = not self.E1active

	def on_sw2_button_press_event(self,widget,event):
		self.E2active = not self.E2active

	def on_sw3_button_press_event(self,widget,event):
		self.E3active = not self.E3active


	def lecture_voies(self) :
		try :
			#lecture de chacune des 3 voies et affichage :
			#vidage du port et tentative de contact avec l'alim :
			self.port_serie.flushInput()
			self.port_serie.write('M')
			#petit délai avant de lire le retour :
			sleep(0.2)
			data_deci = []

			n_data = self.port_serie.inWaiting()
			for i in range (n_data):
				data_deci.append(ord(self.port_serie.read(1)))

			if self.E0active :
				self.lb0.set_text(str("{:4.2f}".format(data_deci[0]*3.3/255)))
				self.pb0.set_fraction(data_deci[0]/255)
			else:
				self.lb0.set_text("X.XX")
				self.pb0.set_fraction(0)

			if self.E1active :
				self.lb1.set_text(str("{:4.2f}".format(data_deci[1]*3.3/255)))
				self.pb1.set_fraction(data_deci[1]/255)
			else:
				self.lb1.set_text("X.XX")
				self.pb1.set_fraction(0)

			if self.E2active :
				self.lb2.set_text(str("{:4.2f}".format(data_deci[2]*3.3/255)))
				self.pb2.set_fraction(data_deci[2]/255)
			else:
				self.lb2.set_text("X.XX")
				self.pb2.set_fraction(0)

			if self.E3active :
				self.lb3.set_text(str("{:4.2f}".format(data_deci[3]*3.3/255)))
				self.pb3.set_fraction(data_deci[3]/255)
			else:
				self.lb3.set_text("X.XX")
				self.pb3.set_fraction(0)

			return True
		except :
			self.lb0.set_text('X.XX')
			self.lb1.set_text('X.XX')
			self.lb2.set_text('X.XX')
			self.lb3.set_text('X.XX')
			return False
		
		self.lecture_voies()

	def on_btRafraichir_clicked(self,widget):
		#Rafraichir la liste des ports série disponibles
		self.comboPort.remove_all()
		self.lister_ports()

	def on_btOuvrir_clicked(self,widget):
		# recuperation des parametres choisis :
		self.port_choisi = self.comboPort.get_active_text()
		debit = 9600
		data_format = serial.EIGHTBITS
		stop = serial.STOPBITS_ONE
		parite = serial.PARITY_NONE
		try:
			# desactivation de widgets (ceux qui ne doivent pas
			# etre modifies une fois le port serie ouvert) :
			self.comboPort.set_sensitive(False)
			self.btRafraichir.set_sensitive(False)
			self.btQuitter.set_sensitive(True)
			

			#ouverture du port serie :
			self.port_serie = serial.Serial(
				port=self.port_choisi,
				baudrate = debit,
				bytesize = data_format,
				parity = parite,
				stopbits = stop,
				timeout=2
			)

			#activation/desactivation de widgets :
			self.btFermer.set_sensitive(True)
			self.btOuvrir.set_sensitive(False)
			
			GObject.timeout_add(500, self.lecture_voies)

		except :
			self.comboPort.set_sensitive(True)
			self.btOuvrir.set_sensitive(True)
			self.btRafraichir.set_sensitive(True)

			#self.bt_fermer.set_sensitive(False)
			self.ouvert = False
			msg = "Erreur lors de l'ouverture du port série : ce port n'est peut-être pas valide, ou bien vous n'avez pas les droits pour accéder aux ports série"
			dialog = Gtk.MessageDialog(None, 0, Gtk.MessageType.WARNING, Gtk.ButtonsType.OK, msg)
			# Montre le dialog
			dialog.run()
			# Destruction du dialog
			dialog.destroy()


	def on_btFermer_clicked(self,widget):
		#fermeture du port série ouvert
		try :
			if self.port_serie.isOpen() == True:
				self.port_serie.close()
				self.comboPort.set_sensitive(True)
				self.btOuvrir.set_sensitive(True)
				self.btRafraichir.set_sensitive(True)
				self.btFermer.set_sensitive(False)
		
		except :
			msgFermer = "Erreur lors de la fermeture du port série !"
			dlgFermer = Gtk.MessageDialog(None, 0, Gtk.MessageType.WARNING, Gtk.ButtonsType.OK, msgFermer)
			dlgFermer.run()
			dlgFermer.destroy()

	def on_btQuitter_clicked(self,widget):
		Gtk.main_quit()

	def destroy(window, self):
		Gtk.main_quit()

def main():
	app = JAUGES()
	Gtk.main()

if __name__ == "__main__":
	sys.exit(main())
